/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.messaging.lifecycle;

import java.util.Map;
import java.util.Properties;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.Session;
import org.robokind.api.common.lifecycle.AbstractLifecycleProvider;
import org.robokind.api.common.lifecycle.utils.DescriptorListBuilder;
import org.robokind.api.messaging.DefaultMessageSender;
import org.robokind.api.messaging.MessageSender;
import org.robokind.api.messaging.RecordSender;
import org.robokind.impl.messaging.JMSBytesMessageSender;
import org.robokind.impl.messaging.utils.JMSAvroPolymorphicRecordBytesAdapter;

public class JMSAvroPolymorphicSenderLifecycle<Msg>
extends AbstractLifecycleProvider<MessageSender, MessageSender<Msg>> {
    private JMSAvroPolymorphicRecordBytesAdapter<Msg> myAdapter;
    protected static final String theSession = "session";
    protected static final String theDestination = "destination";

    public JMSAvroPolymorphicSenderLifecycle(JMSAvroPolymorphicRecordBytesAdapter<Msg> adapter, Class<Msg> messageClass, String senderId, String sessionId, String destinationId) {
        super(new DescriptorListBuilder().dependency(theSession, Session.class).with("connectionId", sessionId).dependency(theDestination, Destination.class).with("destinationId", destinationId).getDescriptors());
        if (adapter == null) {
            throw new NullPointerException();
        }
        this.myAdapter = adapter;
        if (this.myRegistrationProperties == null) {
            this.myRegistrationProperties = new Properties();
        }
        this.myRegistrationProperties.put("messageType", messageClass.getName());
        this.myRegistrationProperties.put("recordType", BytesMessage.class.getName());
        this.myRegistrationProperties.put("messageSenderId", senderId);
    }

    protected MessageSender<Msg> create(Map<String, Object> dependencies) {
        Session session = (Session)dependencies.get(theSession);
        Destination dest = (Destination)dependencies.get(theDestination);
        this.myAdapter.setSession(session);
        JMSBytesMessageSender recSender = new JMSBytesMessageSender();
        recSender.setSession(session);
        recSender.setDestination(dest);
        DefaultMessageSender sender = new DefaultMessageSender();
        sender.setAdapter(this.myAdapter);
        sender.setRecordSender((RecordSender)recSender);
        recSender.openProducer();
        try {
            sender.start();
        }
        catch (Exception ex) {
            return null;
        }
        return sender;
    }

    protected void handleChange(String dependencyId, Object service, Map<String, Object> dependencies) {
        if (this.myService == null) {
            return;
        }
        ((MessageSender)this.myService).stop();
        this.myService = this.isSatisfied() ? this.create(dependencies) : null;
    }

    public Class<MessageSender> getServiceClass() {
        return MessageSender.class;
    }
}

