/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.messaging;

import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import org.apache.avro.Schema;
import org.robokind.api.common.utils.TimeUtils;
import org.robokind.api.messaging.RecordAsyncReceiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMSBytesRecordAsyncReceiver
implements RecordAsyncReceiver<BytesMessage> {
    private static final Logger theLogger = LoggerFactory.getLogger(JMSBytesRecordAsyncReceiver.class);
    private Schema mySchema;
    private RecordAsyncReceiver.RecordHandler<BytesMessage> myRecordHandler;
    private MessageConsumer myMessageConsumer;
    private boolean myConsumeFlag;
    private final Object myHandlerLock = new Object();
    private Thread myPollingThread;
    private boolean myPauseFlag;

    public JMSBytesRecordAsyncReceiver(MessageConsumer consumer) {
        if (consumer == null) {
            throw new NullPointerException();
        }
        this.myMessageConsumer = consumer;
        this.myConsumeFlag = true;
        this.myPauseFlag = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRecordHandler(RecordAsyncReceiver.RecordHandler<BytesMessage> handler) {
        Object object = this.myHandlerLock;
        synchronized (object) {
            if (handler == null) {
                throw new NullPointerException();
            }
            this.myRecordHandler = handler;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsetRecordHandler() {
        Object object = this.myHandlerLock;
        synchronized (object) {
            this.myRecordHandler = null;
        }
    }

    public void start() throws IllegalStateException {
        if (this.myRecordHandler == null) {
            throw new IllegalStateException("RecordHandler cannot be null.");
        }
        if (this.myConsumeFlag && this.myPollingThread != null && this.myPollingThread.isAlive()) {
            if (this.myPauseFlag) {
                this.resume();
            }
            return;
        }
        this.myPollingThread = new Thread(new Runnable(){

            @Override
            public void run() {
                JMSBytesRecordAsyncReceiver.this.eventLoop();
            }
        });
        this.myConsumeFlag = true;
        this.myPauseFlag = false;
        this.myPollingThread.start();
    }

    public void pause() {
        this.myPauseFlag = true;
    }

    public void resume() {
        this.myPauseFlag = false;
    }

    public void stop() {
        this.myConsumeFlag = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void eventLoop() {
        while (this.myConsumeFlag) {
            if (this.myPauseFlag) {
                TimeUtils.sleep((long)10L);
                continue;
            }
            try {
                BytesMessage bytesMsg = this.fetchMessage();
                if (bytesMsg == null) continue;
                Object object = this.myHandlerLock;
                synchronized (object) {
                    if (this.myRecordHandler == null || !this.myConsumeFlag) {
                        return;
                    }
                    this.myRecordHandler.handleRecord((Object)bytesMsg);
                }
            }
            catch (Throwable t) {
                theLogger.warn("Error in Message fetch loop.", t);
                TimeUtils.sleep((long)5L);
            }
        }
    }

    private BytesMessage fetchMessage() {
        try {
            Message msg = this.myMessageConsumer.receive();
            if (msg == null) {
                theLogger.info("Received Null message.");
                return null;
            }
            msg.acknowledge();
            if (!(msg instanceof BytesMessage)) {
                theLogger.warn("Received JMS Message not of type BytesMessage.  Ignoring Message.");
                return null;
            }
            return (BytesMessage)msg;
        }
        catch (JMSException ex) {
            theLogger.error("Error fetching Message.", (Throwable)ex);
            return null;
        }
    }
}

