/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.messaging.utils;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.BytesMessage;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.apache.qpid.client.message.JMSBytesMessage;
import org.jflux.api.core.Adapter;
import org.robokind.api.common.utils.ComplexAdapter;
import org.robokind.api.common.utils.PolymorphicAdapter;
import org.robokind.bind.apache_qpid.QpidUtils;

public class JMSAvroPolymorphicBytesRecordAdapter<Msg>
implements Adapter<BytesMessage, Msg> {
    static final Logger theLogger = Logger.getLogger(JMSAvroPolymorphicBytesRecordAdapter.class.getName());
    private PolymorphicAdapter<BytesMessage, Msg> myAdapter = new PolymorphicAdapter((PolymorphicAdapter.AdapterKeyMap)new ContentTypeKeyMap());

    public <R extends IndexedRecord> void addAdapter(Class<R> recordClass, Schema recordSchema, Adapter<R, Msg> adapter, String contentType) {
        JMSAvroBytesRecordAdapter<R> bytesAdapter = new JMSAvroBytesRecordAdapter<R>(recordClass, recordSchema);
        ComplexAdapter complexAdapter = new ComplexAdapter(bytesAdapter, adapter);
        this.myAdapter.addAdapter(contentType, (Adapter)complexAdapter);
    }

    public Msg adapt(BytesMessage a) {
        return (Msg)this.myAdapter.adapt((Object)a);
    }

    public class JMSAvroBytesRecordAdapter<Rec extends IndexedRecord>
    implements Adapter<BytesMessage, Rec> {
        private Class<Rec> myRecordClass;
        private Schema myRecordSchema;

        public JMSAvroBytesRecordAdapter(Class<Rec> recordClass, Schema schema) {
            if (recordClass == null || schema == null) {
                throw new NullPointerException();
            }
            this.myRecordClass = recordClass;
            this.myRecordSchema = schema;
        }

        public Rec adapt(BytesMessage a) {
            try {
                return (Rec)QpidUtils.unpackAvroMessage(this.myRecordClass, null, (Schema)this.myRecordSchema, (BytesMessage)a);
            }
            catch (Exception ex) {
                theLogger.log(Level.WARNING, "There was an error upacking the message.", ex);
                return null;
            }
        }
    }

    private class ContentTypeKeyMap
    implements PolymorphicAdapter.AdapterKeyMap<BytesMessage> {
        private ContentTypeKeyMap() {
        }

        public String getKey(BytesMessage t) {
            return ((JMSBytesMessage)t).getEncoding();
        }
    }
}

