/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.messaging;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.BytesMessage;
import org.apache.avro.generic.IndexedRecord;
import org.apache.qpid.client.message.JMSBytesMessage;
import org.robokind.api.messaging.RecordSender;
import org.robokind.bind.apache_qpid.QpidUtils;
import org.robokind.impl.messaging.JMSBytesMessageSender;

public class JMSAvroRecordSender<T extends IndexedRecord>
implements RecordSender<T> {
    static final Logger theLogger = Logger.getLogger(JMSAvroRecordSender.class.getName());
    private JMSBytesMessageSender myBytesSender;

    public JMSAvroRecordSender(JMSBytesMessageSender sender) {
        if (sender == null) {
            throw new NullPointerException();
        }
        this.myBytesSender = sender;
    }

    public void sendRecord(T record) {
        this.sendRecord(record, null);
    }

    public void sendRecord(T record, String contentType) {
        if (record == null) {
            throw new NullPointerException();
        }
        BytesMessage msg = this.myBytesSender.createBytesMessage();
        if (msg == null) {
            theLogger.log(Level.WARNING, "Error creating BytesMessage.");
            return;
        }
        try {
            QpidUtils.packAvroMessage(record, (BytesMessage)msg);
        }
        catch (Exception ex) {
            theLogger.log(Level.WARNING, "Error serializing record.", ex);
            return;
        }
        if (contentType != null) {
            ((JMSBytesMessage)msg).setContentType(contentType);
            ((JMSBytesMessage)msg).setEncoding(contentType);
        }
        this.myBytesSender.sendRecord(msg);
    }
}

