/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.messaging;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import org.robokind.api.messaging.RecordSender;

public class JMSBytesMessageSender
implements RecordSender<BytesMessage> {
    static final Logger theLogger = Logger.getLogger(JMSBytesMessageSender.class.getName());
    private Session mySession;
    private Destination myDestination;
    private MessageProducer myMessageProducer;

    public void setSession(Session session) {
        this.mySession = session;
    }

    public void setDestination(Destination dest) {
        this.myDestination = dest;
    }

    public void closeProducer() {
        if (this.myMessageProducer == null) {
            return;
        }
        try {
            this.myMessageProducer.close();
        }
        catch (JMSException ex) {
            theLogger.log(Level.WARNING, "Error closing MessageProducer.", ex);
        }
    }

    public void openProducer() {
        if (this.mySession == null || this.myDestination == null) {
            return;
        }
        if (this.myMessageProducer != null) {
            theLogger.log(Level.WARNING, "Cannot open MessageProducer.  MessageProducer already open.");
            return;
        }
        try {
            this.myMessageProducer = this.mySession.createProducer(this.myDestination);
        }
        catch (JMSException ex) {
            theLogger.log(Level.WARNING, "Error opening MessageProducer.", ex);
        }
    }

    BytesMessage createBytesMessage() {
        if (this.mySession == null) {
            return null;
        }
        try {
            return this.mySession.createBytesMessage();
        }
        catch (JMSException ex) {
            return null;
        }
    }

    public void sendRecord(BytesMessage message) {
        if (message == null) {
            throw new NullPointerException();
        }
        if (this.myMessageProducer == null) {
            theLogger.log(Level.WARNING, "Not connected, unable to send message.");
            return;
        }
        try {
            this.myMessageProducer.send((Message)message);
        }
        catch (Exception ex) {
            theLogger.log(Level.WARNING, "Error sending message.", ex);
        }
    }
}

