/*
 * Copyright 2012 Hanson Robokind LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.robokind.impl.messaging.osgi;

import org.jflux.api.core.util.EmptyAdapter;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.robokind.api.common.lifecycle.utils.SimpleLifecycle;
import org.robokind.api.common.osgi.lifecycle.OSGiComponent;
import org.robokind.api.common.osgi.lifecycle.OSGiComponentFactory;
import org.robokind.api.messaging.services.ServiceCommand;
import org.robokind.api.messaging.services.ServiceCommandFactory;
import org.robokind.api.messaging.services.ServiceError;
import org.robokind.impl.messaging.JMSAvroServiceFacade;
import org.robokind.impl.messaging.ServiceCommandRecord;
import org.robokind.impl.messaging.ServiceErrorRecord;
import org.robokind.impl.messaging.config.RKMessagingConfigUtils;
import org.robokind.impl.messaging.services.PortableServiceCommand;

/**
 *
 * @author Matthew Stevenson
 */
public class Activator implements BundleActivator {
    
    @Override
    public void start(BundleContext context) throws Exception {
        RKMessagingConfigUtils.registerAvroSerializationConfig(
                ServiceCommand.class, 
                ServiceCommandRecord.class, 
                ServiceCommandRecord.SCHEMA$, 
                new EmptyAdapter(), 
                new EmptyAdapter(), 
                JMSAvroServiceFacade.COMMAND_MIME_TYPE, null, 
                new OSGiComponentFactory(context));
        
        RKMessagingConfigUtils.registerAvroSerializationConfig(
                ServiceError.class, 
                ServiceErrorRecord.class, 
                ServiceErrorRecord.SCHEMA$, 
                new EmptyAdapter(), 
                new EmptyAdapter(), 
                JMSAvroServiceFacade.AVRO_MIME_TYPE, null, 
                new OSGiComponentFactory(context));
        
        new OSGiComponent(context, 
                new SimpleLifecycle(new PortableServiceCommand.Factory(), 
                        ServiceCommandFactory.class)).start();
    }
    
    @Override
    public void stop(BundleContext context) throws Exception {
        //TODO add deactivation code here
    }
}
