/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.messaging;

import java.util.logging.Logger;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.robokind.api.messaging.DefaultMessageAsyncReceiver;
import org.robokind.impl.messaging.JMSAvroRecordAsyncReceiver;

public class JMSAvroMessageAsyncReceiver<Msg, Rec extends IndexedRecord>
extends DefaultMessageAsyncReceiver<Msg, Rec> {
    private static final Logger theLogger = Logger.getLogger(JMSAvroMessageAsyncReceiver.class.getName());
    private Session mySession;
    private Destination myDestination;
    private Class<Rec> myRecordClass;
    private Schema myRecordSchema;

    public JMSAvroMessageAsyncReceiver(Session session, Destination destination, Class<Rec> recordClass, Schema recordSchema) {
        if (session == null || destination == null || recordClass == null) {
            throw new NullPointerException();
        }
        this.mySession = session;
        this.myDestination = destination;
        this.myRecordClass = recordClass;
        this.myRecordSchema = recordSchema;
    }

    public void start() throws JMSException, Exception {
        MessageConsumer consumer = this.mySession.createConsumer(this.myDestination);
        JMSAvroRecordAsyncReceiver<Rec> pollingService = new JMSAvroRecordAsyncReceiver<Rec>(this.myRecordClass, this.myRecordSchema, consumer);
        this.setRecordReceiver(pollingService);
        super.start();
    }
}

