/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.messaging;

import java.io.IOException;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import org.apache.avro.generic.IndexedRecord;
import org.apache.qpid.client.message.JMSBytesMessage;
import org.jflux.api.messaging.rk.MessageAsyncReceiver;
import org.jflux.api.messaging.rk.MessageSender;
import org.jflux.impl.messaging.rk.common.QpidUtils;
import org.robokind.api.common.playable.AbstractPlayable;
import org.robokind.api.common.utils.TimeUtils;
import org.robokind.api.messaging.services.RemoteServiceClient;
import org.robokind.api.messaging.services.ServiceCommand;
import org.robokind.api.messaging.services.ServiceCommandFactory;
import org.robokind.api.messaging.services.ServiceError;
import org.robokind.impl.messaging.ServiceCommandRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMSAvroServiceFacade<Config extends IndexedRecord>
extends AbstractPlayable
implements RemoteServiceClient<Config> {
    private static final Logger theLogger = LoggerFactory.getLogger(JMSAvroServiceFacade.class);
    public static final String CONFIG_MIME_TYPE = "application/config";
    public static final String AVRO_MIME_TYPE = "application/avro";
    public static final String COMMAND_MIME_TYPE = "application/service-command";
    private Class<Config> myConfigClass;
    private Config myReusableConfig;
    private Session mySession;
    private MessageProducer myCommandSender;
    private MessageConsumer myErrorReceiver;

    public JMSAvroServiceFacade(Class<Config> configClass, Config reusableConfig, Session session, Destination commandDest, Destination errorDest) throws JMSException {
        this.myConfigClass = configClass;
        this.myReusableConfig = reusableConfig;
        this.mySession = session;
        this.myCommandSender = session.createProducer(commandDest);
        this.myErrorReceiver = session.createConsumer(errorDest);
    }

    public JMSAvroServiceFacade(Class<Config> configClass, Config reusableConfig, Session session, MessageProducer commandSender, MessageConsumer errorReceiver) {
        this.myConfigClass = configClass;
        this.myReusableConfig = reusableConfig;
        this.mySession = session;
        this.myCommandSender = commandSender;
        this.myErrorReceiver = errorReceiver;
    }

    public void setSession(Session session) {
        this.mySession = session;
    }

    public void setSender(MessageProducer producer) {
        this.myCommandSender = producer;
    }

    public void setReceiver(MessageConsumer consumer) {
        this.myErrorReceiver = consumer;
    }

    public void initialize(Config config) throws IOException, JMSException, Exception {
        this.send((IndexedRecord)config, CONFIG_MIME_TYPE);
    }

    public boolean onStart(long time) {
        return this.sendCommand("start");
    }

    public boolean onPause(long time) {
        return this.sendCommand("pause");
    }

    public boolean onResume(long time) {
        return this.sendCommand("resume");
    }

    public boolean onComplete(long time) {
        return this.sendCommand("stop");
    }

    public boolean onStop(long time) {
        return this.sendCommand("stop");
    }

    protected <T extends IndexedRecord> void send(T t, String contentType) throws IOException, JMSException {
        BytesMessage message = this.mySession.createBytesMessage();
        ((JMSBytesMessage)message).setContentType(contentType);
        QpidUtils.packAvroMessage(t, (BytesMessage)message);
        this.myCommandSender.send((Message)message);
    }

    protected boolean sendCommand(String command) {
        ServiceCommandRecord rec = new ServiceCommandRecord();
        rec.setSourceId("src");
        rec.setDestinationId("dest");
        rec.setTimestampMillisecUTC(TimeUtils.now());
        rec.setCommand(command);
        try {
            this.send(rec, COMMAND_MIME_TYPE);
            return true;
        }
        catch (Exception ex) {
            theLogger.error("Error sending Start Command.", (Throwable)ex);
            return false;
        }
    }

    public Class<Config> getConfigClass() {
        return this.myConfigClass;
    }

    public Config getReusableConfig() {
        return this.myReusableConfig;
    }

    public void setCommandSender(MessageSender<ServiceCommand> sender) {
    }

    public void setConfigSender(MessageSender<Config> sender) {
    }

    public void setErrorReceiver(MessageAsyncReceiver<ServiceError> receiver) {
    }

    public void setCommandFactory(ServiceCommandFactory factory) {
    }

    public String getClientId() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getHostId() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

