/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.motion.dynamixel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.robokind.api.common.config.VersionProperty;
import org.robokind.api.common.position.NormalizedDouble;
import org.robokind.api.common.utils.Utils;
import org.robokind.api.motion.servos.ServoController;
import org.robokind.api.motion.servos.config.ServoConfig;
import org.robokind.api.motion.servos.utils.ConnectionStatus;
import org.robokind.impl.motion.dynamixel.DynamixelControllerConfig;
import org.robokind.impl.motion.dynamixel.DynamixelServo;
import org.robokind.impl.motion.dynamixel.enums.ErrorStatus;
import org.robokind.impl.motion.dynamixel.enums.Instruction;
import org.robokind.impl.motion.dynamixel.enums.Register;
import org.robokind.impl.motion.serial.SerialServoController;
import org.robokind.impl.motion.serial.SerialServoControllerConfig;

public class DynamixelController
extends SerialServoController<DynamixelServo.Id, ServoConfig<DynamixelServo.Id>, DynamixelServo, DynamixelControllerConfig> {
    private static final Logger theLogger = Logger.getLogger(DynamixelController.class.getName());
    public static final String VERSION_NAME = "Dynamixel RX";
    public static final String VERSION_NUMBER = "1.0";
    public static final VersionProperty VERSION = new VersionProperty("Dynamixel RX", "1.0");
    public static final DynamixelServo.Id BROADCAST_ID = new DynamixelServo.Id();
    private Map<DynamixelServo.Id, ServoConfig> myUnresponsiveServos;
    private Boolean myEnabledFlag = true;
    private static final int theSyncCount = 5;

    public DynamixelController(DynamixelControllerConfig config) {
        super((SerialServoControllerConfig)config);
        this.setTimeoutLength(20);
    }

    protected synchronized boolean setServos() {
        this.myServos.clear();
        this.myServoMap.clear();
        this.myUnresponsiveServos = new HashMap<DynamixelServo.Id, ServoConfig>();
        for (ServoConfig param : ((DynamixelControllerConfig)this.myConfig).getServoConfigs().values()) {
            DynamixelServo.Id id = (DynamixelServo.Id)param.getServoId();
            if (!this.ping(id)) {
                this.myUnresponsiveServos.put((DynamixelServo.Id)param.getServoId(), param);
                theLogger.log(Level.WARNING, "Unable to ping Dynamixel {0}.", new Object[]{param.getServoId()});
                continue;
            }
            DynamixelServo servo = new DynamixelServo((ServoConfig<DynamixelServo.Id>)param, this);
            this.myServos.add(servo);
            DynamixelServo.Id sId = (DynamixelServo.Id)servo.getId();
            ServoController.ServoId servoId = new ServoController.ServoId(this.getId(), (Object)sId);
            this.myServoMap.put(servoId, servo);
            this.initServo(servo);
        }
        ServoController.ServoId[] ids = this.myServoMap.keySet().toArray(new ServoController.ServoId[0]);
        return this.moveServosSync(3000L, ids);
    }

    private void initServo(DynamixelServo servo) {
        servo.setEnabled(this.myEnabledFlag);
        NormalizedDouble def = servo.getDefaultPosition();
        servo.setGoalPosition(def);
    }

    public boolean moveServo(ServoController.ServoId<DynamixelServo.Id> id, long lenMillisec) {
        return this.moveServos(new ServoController.ServoId[]{id}, 1, 0, lenMillisec);
    }

    public boolean moveServos(ServoController.ServoId<DynamixelServo.Id>[] ids, int len, int offset, long lenMillisec) {
        if (ConnectionStatus.CONNECTED != this.myConnectionStatus) {
            return false;
        }
        return this.moveServosSync(lenMillisec, ids);
    }

    private synchronized boolean moveServosSync(long lenMillisec, ServoController.ServoId<DynamixelServo.Id> ... ids) {
        Boolean e = this.getEnabled();
        if (e == null || !e.booleanValue()) {
            return true;
        }
        ArrayList<Byte> data = new ArrayList<Byte>(ids.length * 5);
        for (ServoController.ServoId<DynamixelServo.Id> id : ids) {
            DynamixelServo servo = (DynamixelServo)((Object)this.myServoMap.get(id));
            if (servo == null || !servo.getEnabled().booleanValue() || !servo.changed()) continue;
            Integer goal = servo.getAbsoluteGoalPosition();
            Integer cur = servo.getPreviousPosition();
            if (goal == null) continue;
            lenMillisec = Math.max(lenMillisec, 1L);
            int speed = this.calculateSpeed(cur, goal, lenMillisec);
            data.add((byte)servo.getPhysicalId().getIntValue());
            data.add((byte)(goal & 0xFF));
            data.add((byte)(goal >> 8));
            data.add((byte)(speed & 0xFF));
            data.add((byte)(speed >> 8));
            servo.setPreviousPosition(goal);
        }
        if (data.isEmpty()) {
            return true;
        }
        return this.syncWrite(Register.GoalPosition, data.size() / 5, data);
    }

    private int calculateSpeed(int cur, int goal, long time) {
        int dist = Math.abs(goal - cur);
        double theta = (double)dist * 300.0 / 1023.0;
        time = Math.max(time, 1L);
        double rpm = theta * (60000.0 / (double)time) / 360.0;
        double speed = rpm / 0.111;
        return Utils.bound((int)((int)speed), (int)1, (int)1023);
    }

    public boolean moveAllServos(long lenMillisec) {
        ServoController.ServoId[] ids = this.myServoMap.keySet().toArray(new ServoController.ServoId[0]);
        return this.moveServos(ids, ids.length, 0, lenMillisec);
    }

    protected synchronized Packet readPacket() {
        boolean badId;
        Packet packet = new Packet();
        if (this.myPort.read() != 255 || this.myPort.read() != 255) {
            theLogger.log(Level.WARNING, "Error reading Dynamixel Packet.  Incorrect header bytes.");
            packet.error = true;
            return packet;
        }
        int receivedId = this.myPort.read();
        packet.length = this.myPort.read() - 2;
        int error = this.myPort.read();
        packet.errors = ErrorStatus.getStatusList(error);
        packet.data = this.myPort.read(packet.length);
        packet.error = packet.length != packet.data.length;
        byte chkCalc = Utils.checksum((byte[])packet.data, (int)0, (int)packet.data.length, (boolean)true, (byte[])new byte[]{(byte)receivedId, (byte)(packet.length + 2), (byte)error});
        byte chkRec = (byte)this.myPort.read();
        boolean chksum = chkCalc != chkRec;
        boolean dataLen = packet.length != packet.data.length;
        boolean errorFlag = !packet.errors.isEmpty();
        boolean bl = badId = !DynamixelServo.Id.isValidId(receivedId);
        if (!badId) {
            packet.id = new DynamixelServo.Id(receivedId);
        }
        boolean bl2 = packet.error = chksum || dataLen || errorFlag || badId;
        if (!packet.error) {
            return packet;
        }
        if (chksum) {
            theLogger.log(Level.WARNING, "Error reading Dynamixel packet. Bad checksum.");
        }
        if (dataLen) {
            theLogger.log(Level.WARNING, "Error reading Dynamixel packet.  Data not recieved.");
        }
        if (errorFlag) {
            int len = packet.errors.size();
            String errorStr = "";
            for (int i = 0; i < len; ++i) {
                ErrorStatus e = packet.errors.get(i);
                errorStr = errorStr + e.name();
                errorStr = errorStr + (i < len - 1 ? ", " : ".");
            }
            theLogger.log(Level.WARNING, "Error reading Dynamixel packet.  {0}", errorStr);
        }
        if (badId) {
            theLogger.log(Level.WARNING, "Error reading Dynamixel packet.  Invalid Id Recieved.");
        }
        return packet;
    }

    protected synchronized boolean writeInstruction(DynamixelServo.Id id, Instruction ins, byte ... params) {
        int paramLen = params == null ? 0 : params.length;
        byte[] data = new byte[6 + paramLen];
        data[0] = -1;
        data[1] = -1;
        data[2] = (byte)id.getIntValue();
        data[3] = (byte)(paramLen + 2);
        data[4] = ins.getByte();
        System.arraycopy(params, 0, data, 5, paramLen);
        data[data.length - 1] = Utils.checksum((byte[])data, (int)2, (int)(data.length - 1), (boolean)true, (byte[])new byte[0]);
        return this.myPort.write(data) && this.myPort.flushWriter();
    }

    public synchronized boolean ping(DynamixelServo.Id id) {
        this.writeInstruction(id, Instruction.Ping, new byte[0]);
        Packet packet = this.readPacket();
        return !packet.error && packet.id.equals(id);
    }

    public int readRegister(DynamixelServo.Id id, Register reg) {
        return this.readRegisters(id, reg, reg)[0];
    }

    public synchronized int[] readRegisters(DynamixelServo.Id id, Register regFirst, Register regLast) {
        byte byteCount = (byte)(regLast.getByte() - regFirst.getByte() + regLast.getLength());
        Register[] regs = Register.values();
        int first = regFirst.ordinal();
        int last = regLast.ordinal();
        int[] values = new int[last - first + 1];
        this.writeInstruction(id, Instruction.ReadData, regFirst.getByte(), byteCount);
        Packet packet = this.readPacket();
        for (int i = first; i <= last; ++i) {
            Register reg = regs[i];
            int offset = reg.getByte() - regFirst.getByte();
            values[i - first] = Utils.unsign((byte)packet.data[offset]);
            if (reg.getLength() <= 1) continue;
            int n = i - first;
            values[n] = values[n] + (Utils.unsign((byte)packet.data[offset + 1]) << 8);
        }
        return values;
    }

    protected boolean writeRegister(DynamixelServo.Id id, Register reg, Integer value, Boolean deferred) {
        byte[] params = new byte[reg.getLength() + 1];
        params[0] = reg.getByte();
        if (reg.getLength() == 1) {
            params[1] = value.byteValue();
        } else {
            params[1] = (byte)(value & 0xFF);
            params[2] = (byte)(value >> 8);
        }
        boolean write = this.writeInstruction(id, deferred != false ? Instruction.RegWrite : Instruction.WriteData, params);
        if (!write) {
            return false;
        }
        if (!deferred.booleanValue()) {
            return this.readPacket().error;
        }
        return true;
    }

    protected boolean syncWrite(Register startAddress, int jointCount, List<Byte> params) {
        int paramLen = params.size();
        if (paramLen % jointCount != 0) {
            throw new IllegalArgumentException("Dyanmixel SyncWrite params length() error");
        }
        byte[] data = new byte[paramLen + 2];
        data[0] = startAddress.getByte();
        data[1] = (byte)(paramLen / jointCount - 1);
        for (int i = 0; i < paramLen; ++i) {
            data[i + 2] = params.get(i);
        }
        return this.writeInstruction(BROADCAST_ID, Instruction.SyncWrite, data);
    }

    protected DynamixelServo connectServo(ServoConfig config) {
        return new DynamixelServo((ServoConfig<DynamixelServo.Id>)config, this);
    }

    protected boolean disconnectServo(ServoController.ServoId<DynamixelServo.Id> id) {
        return true;
    }

    public void setEnabled(Boolean enabled) {
        Boolean old = this.myEnabledFlag;
        this.myEnabledFlag = enabled;
        for (DynamixelServo servo : this.myServos) {
            servo.setEnabled(enabled);
        }
        this.firePropertyChange("enabled", old, enabled);
    }

    public Boolean getEnabled() {
        return this.myEnabledFlag;
    }

    public Class<DynamixelServo.Id> getServoIdClass() {
        return DynamixelServo.Id.class;
    }

    protected class Packet {
        DynamixelServo.Id id = BROADCAST_ID;
        byte[] data = null;
        int length;
        boolean error = false;
        List<ErrorStatus> errors = null;

        protected Packet() {
        }
    }
}

