/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.motion.dynamixel.osgi;

import java.util.Dictionary;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.robokind.api.common.services.ServiceConfigurationLoader;
import org.robokind.api.common.services.ServiceFactory;
import org.robokind.api.motion.servos.ServoController;
import org.robokind.api.motion.servos.utils.ServoIdReader;
import org.robokind.api.motion.servos.utils.ServoJointAdapter;
import org.robokind.impl.motion.dynamixel.DynamixelConnector;
import org.robokind.impl.motion.dynamixel.DynamixelController;
import org.robokind.impl.motion.dynamixel.DynamixelControllerConfig;
import org.robokind.impl.motion.dynamixel.DynamixelJointAdapter;
import org.robokind.impl.motion.dynamixel.DynamixelServoIdReader;

public class Activator
implements BundleActivator {
    private static final Logger theLogger = Logger.getLogger(Activator.class.getName());

    public void start(BundleContext context) throws Exception {
        theLogger.log(Level.INFO, "DynamixelServoBundle Activation Begin.");
        this.registerDynamixelConnector(context);
        this.registerServoJointAdapter(context);
        this.registerServoIdReader(context);
        this.registerDynamixelConfigLoader(context);
        theLogger.log(Level.INFO, "DynamixelServoBundle Activation Complete.");
    }

    private void registerDynamixelConnector(BundleContext context) {
        DynamixelConnector connector = new DynamixelConnector();
        Properties props = new Properties();
        props.put("ServiceVersion", DynamixelController.VERSION.toString());
        props.put("ServiceClass", ServoController.class.getName());
        context.registerService(ServiceFactory.class.getName(), (Object)connector, (Dictionary)props);
        theLogger.log(Level.INFO, "DynamixelConnector Service Registered Successfully.");
    }

    private void registerServoJointAdapter(BundleContext context) {
        DynamixelJointAdapter adapter = new DynamixelJointAdapter();
        Properties props = new Properties();
        props.put("servoControllerVersion", DynamixelController.VERSION.toString());
        context.registerService(ServoJointAdapter.class.getName(), (Object)adapter, (Dictionary)props);
        theLogger.log(Level.INFO, "DynamixelJointAdapter Service Registered Successfully.");
    }

    private void registerServoIdReader(BundleContext context) {
        DynamixelServoIdReader reader = new DynamixelServoIdReader();
        Properties props = new Properties();
        props.put("servoControllerVersion", DynamixelController.VERSION.toString());
        context.registerService(ServoIdReader.class.getName(), (Object)reader, (Dictionary)props);
        theLogger.log(Level.INFO, "DynamixelServoIdReader Service Registered Successfully.");
    }

    private void registerDynamixelConfigLoader(BundleContext context) {
        DynamixelControllerConfig.Reader reader = new DynamixelControllerConfig.Reader();
        Properties props = new Properties();
        props.put("ConfigurationFormatVersion", DynamixelControllerConfig.Reader.VERSION.toString());
        props.put("ServiceConfigurationClass", DynamixelControllerConfig.class.getName());
        props.put("ServiceConfigParameterClass", HierarchicalConfiguration.class.getName());
        context.registerService(ServiceConfigurationLoader.class.getName(), (Object)reader, (Dictionary)props);
        theLogger.log(Level.INFO, "SerialServoControllerConfig XML Reader");
    }

    public void stop(BundleContext context) throws Exception {
    }
}

