/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.motion.dynamixel.properties;

import org.robokind.api.common.types.Voltage;
import org.robokind.api.motion.joint_properties.ReadVoltage;
import org.robokind.impl.motion.dynamixel.DynamixelServo;

public class VoltageProperty
extends ReadVoltage {
    private DynamixelServo myDynamixelServo;
    protected Voltage myCachedValue;

    public VoltageProperty(DynamixelServo dyna) {
        if (dyna == null) {
            throw new NullPointerException();
        }
        this.myDynamixelServo = dyna;
    }

    public Voltage getValue() {
        Voltage old = this.myCachedValue;
        this.myCachedValue = this.readValue();
        this.firePropertyChange(this.getPropertyName(), old, this.myCachedValue);
        return this.myCachedValue;
    }

    private Voltage readValue() {
        Integer dynaVoltage = this.myDynamixelServo.getCurrentVoltage();
        if (dynaVoltage != null) {
            double volts = (double)dynaVoltage.intValue() / 10.0;
            return new Voltage(volts);
        }
        return null;
    }

    public Voltage getCachedValue() {
        return this.myCachedValue;
    }
}

