/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.motion.dynamixel.feedback;

import java.util.ArrayList;
import java.util.List;
import org.robokind.api.motion.servos.ServoController;
import org.robokind.impl.motion.dynamixel.DynamixelController;
import org.robokind.impl.motion.dynamixel.DynamixelServo;
import org.robokind.impl.motion.dynamixel.feedback.ConcurrentDynamixelCache;
import org.robokind.impl.motion.dynamixel.feedback.DynamixelControlSettings;
import org.robokind.impl.motion.dynamixel.feedback.utils.FeedbackUtils;

public class TemperatureMonitor {
    private List<ServoController.ServoId<DynamixelServo.Id>> myHotServoIds;
    private boolean myCooldownFlag;
    private DynamixelController myController;
    private DynamixelControlSettings mySettings;
    private ConcurrentDynamixelCache myCache;

    public TemperatureMonitor(DynamixelController controller, DynamixelControlSettings settings, ConcurrentDynamixelCache cache) {
        if (controller == null || settings == null || cache == null) {
            throw new NullPointerException();
        }
        this.myController = controller;
        this.mySettings = settings;
        this.myCache = cache;
        this.myHotServoIds = new ArrayList<ServoController.ServoId<DynamixelServo.Id>>();
    }

    public boolean cooldown() {
        if (this.myCooldownFlag) {
            if (!FeedbackUtils.isOverLimit(this.myCache, 4, (int)this.mySettings.getCooldownTemperature(), 1)) {
                this.myCooldownFlag = false;
                return false;
            }
            return true;
        }
        return this.disableHotServos((int)this.mySettings.getMaxRunTemperature());
    }

    public boolean disableHotServos(int maxTemp) {
        List<DynamixelServo.Id> hotServos = FeedbackUtils.getHotServos(this.myCache, (int)this.mySettings.getMaxRunTemperature());
        if (hotServos == null || hotServos.isEmpty()) {
            return false;
        }
        this.myCooldownFlag = true;
        for (DynamixelServo.Id id : hotServos) {
            ServoController.ServoId globalId = new ServoController.ServoId(this.myController.getId(), (Object)id);
            if (this.myHotServoIds.contains(globalId)) continue;
            this.myHotServoIds.add((ServoController.ServoId<DynamixelServo.Id>)globalId);
            DynamixelServo servo = (DynamixelServo)this.myController.getServo(globalId);
            servo.setEnabled(false);
        }
        return true;
    }
}

