/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.motion.dynamixel.properties;

import org.robokind.api.common.position.NormalizedDouble;
import org.robokind.api.motion.JointProperty;
import org.robokind.impl.motion.dynamixel.DynamixelServo;

public class AbsolutePositionProperty
extends JointProperty.ReadOnly<Integer> {
    private DynamixelServo myServo;

    public AbsolutePositionProperty(DynamixelServo servo) {
        this.myServo = servo;
    }

    public String getPropertyName() {
        return "absGoalPosition";
    }

    public String getDisplayName() {
        return "Absolute Goal Postion";
    }

    public Class<Integer> getPropertyClass() {
        return Integer.class;
    }

    public Integer getValue() {
        double min = this.myServo.getConfig().getMinPosition();
        double max = this.myServo.getConfig().getMaxPosition();
        NormalizedDouble val = this.myServo.getGoalPosition();
        if (val == null) {
            return null;
        }
        double cur = val.getValue();
        double range = max - min;
        cur = cur * range + min;
        return (int)cur;
    }

    public Integer getCachedValue() {
        return this.getValue();
    }
}

