/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.motion.dynamixel.feedback;

import org.robokind.impl.motion.dynamixel.DynamixelServo;

public class FeedbackUpdateValues {
    public static final int POSITION = 0;
    public static final int SPEED = 1;
    public static final int LOAD = 2;
    public static final int VOLTAGE = 3;
    public static final int TEMPERATURE = 4;
    private DynamixelServo.Id myId;
    private int[] myFeedbackValues;
    private long myFeedbackTimestamp;

    public FeedbackUpdateValues(DynamixelServo.Id id, int[] vals, long timestamp) {
        this.myId = id;
        this.myFeedbackValues = vals;
        vals[1] = this.setDirection(vals[1]);
        vals[2] = this.setDirection(vals[2]);
        this.myFeedbackTimestamp = timestamp;
    }

    private int setDirection(int val) {
        if ((val & 0x400) != 0) {
            return -(val & 0x3FF);
        }
        return val;
    }

    public DynamixelServo.Id getServoId() {
        return this.myId;
    }

    public int getCurrentPosition() {
        return this.myFeedbackValues[0];
    }

    public int getCurrentSpeed() {
        return this.myFeedbackValues[1];
    }

    public int getCurrentLoad() {
        return this.myFeedbackValues[2];
    }

    public int getCurrentVoltage() {
        return this.myFeedbackValues[3];
    }

    public int getCurrentTemperature() {
        return this.myFeedbackValues[4];
    }

    public long getUpdateTimestamp() {
        return this.myFeedbackTimestamp;
    }

    public int[] getValues() {
        return this.myFeedbackValues;
    }
}

