/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.motion.dynamixel.properties;

import org.robokind.api.common.position.IntegerRange;
import org.robokind.api.common.position.NormalizableRange;
import org.robokind.api.common.position.NormalizedDouble;
import org.robokind.api.motion.JointProperty;
import org.robokind.impl.motion.dynamixel.DynamixelServo;

public class AbsCurrentPositionProperty
extends JointProperty.ReadOnly<Integer> {
    private DynamixelServo myServo;

    public AbsCurrentPositionProperty(DynamixelServo servo) {
        if (servo == null) {
            throw new NullPointerException();
        }
        this.myServo = servo;
    }

    public String getPropertyName() {
        return "absCurrentPosition";
    }

    public String getDisplayName() {
        return "Absolute Current Postion";
    }

    public Class<Integer> getPropertyClass() {
        return Integer.class;
    }

    public Integer getValue() {
        double min = this.myServo.getConfig().getMinPosition();
        double max = this.myServo.getConfig().getMaxPosition();
        NormalizedDouble val = this.myServo.getCurrentPosition();
        if (val == null) {
            return null;
        }
        double cur = val.getValue();
        double range = max - min;
        cur = cur * range + min;
        return (int)cur;
    }

    public NormalizableRange<Integer> getNormalizableRange() {
        return new IntegerRange(0, 1023);
    }
}

