/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.motion.openservo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.robokind.api.common.config.VersionProperty;
import org.robokind.api.common.position.NormalizedDouble;
import org.robokind.api.common.utils.TimeUtils;
import org.robokind.api.motion.servos.AbstractServoController;
import org.robokind.api.motion.servos.ServoController;
import org.robokind.api.motion.servos.config.ServoConfig;
import org.robokind.api.motion.servos.config.ServoControllerConfig;
import org.robokind.api.motion.servos.utils.ConnectionStatus;
import org.robokind.impl.motion.dynamixel.feedback.DynamixelControlLoop;
import org.robokind.impl.motion.dynamixel.feedback.DynamixelControlSettings;
import org.robokind.impl.motion.dynamixel.feedback.GoalUpdateValues;
import org.robokind.impl.motion.openservo.OpenServo;
import org.robokind.impl.motion.openservo.OpenServoCommandSet;
import org.robokind.impl.motion.openservo.feedback.ConcurrentOpenServoCache;
import org.robokind.impl.motion.openservo.feedback.DynamixelTracker;
import org.robokind.impl.motion.openservo.feedback.OpenServoControlLoop;
import org.robokind.impl.motion.openservo.utils.OpenServoControllerConfig;

public class OpenServoController
extends AbstractServoController<OpenServo.Id, ServoConfig<OpenServo.Id>, OpenServo, OpenServoControllerConfig> {
    private static final Logger theLogger = Logger.getLogger(OpenServoController.class.getName());
    public static final String VERSION_NAME = "OpenServo";
    public static final String VERSION_NUMBER = "1.0";
    public static final VersionProperty VERSION = new VersionProperty("OpenServo", "1.0");
    private boolean myEnabledFlag = true;
    private ConcurrentOpenServoCache myCache;
    private OpenServoControlLoop myControlLoop;

    public OpenServoController(OpenServoControllerConfig config) {
        super((ServoControllerConfig)config);
        DynamixelControlSettings settings = new DynamixelControlSettings(1, 0, 77.0, 69.0, 0.0, 100);
        this.myCache = new ConcurrentOpenServoCache();
        this.myControlLoop = new OpenServoControlLoop(this, settings);
        this.myControlLoop.setPortSource(new DynamixelTracker(this.myControlLoop));
        this.setServos();
    }

    public ConcurrentOpenServoCache getCache() {
        return this.myCache;
    }

    private synchronized boolean setServos() {
        this.myServos.clear();
        this.myServoMap.clear();
        for (ServoConfig param : ((OpenServoControllerConfig)this.myConfig).getServoConfigs().values()) {
            OpenServo servo = new OpenServo((ServoConfig<OpenServo.Id>)param, this);
            this.myServos.add(servo);
            OpenServo.Id sId = (OpenServo.Id)servo.getId();
            ServoController.ServoId servoId = new ServoController.ServoId(this.getId(), (Object)sId);
            this.myServoMap.put(servoId, servo);
            this.initServo(servo);
        }
        return true;
    }

    private void initServo(OpenServo servo) {
        servo.setEnabled(this.myEnabledFlag);
        NormalizedDouble def = servo.getDefaultPosition();
        servo.setGoalPosition(def);
    }

    protected OpenServo connectServo(ServoConfig<OpenServo.Id> config) {
        return new OpenServo(config, this);
    }

    protected boolean disconnectServo(ServoController.ServoId<OpenServo.Id> id) {
        return true;
    }

    public boolean connect() {
        if (ConnectionStatus.DISCONNECTED != this.myConnectionStatus) {
            theLogger.log(Level.WARNING, "Error: Port must be disconnected before connecting.");
            return false;
        }
        ArrayList<OpenServo.Id> ids = new ArrayList<OpenServo.Id>(this.myServos.size());
        for (OpenServo s : this.myServos) {
            OpenServo.Id id = (OpenServo.Id)s.getId();
            ids.add(id);
        }
        this.myControlLoop.start(ids);
        this.setConnectStatus(ConnectionStatus.CONNECTED);
        return true;
    }

    public boolean disconnect() {
        this.setConnectStatus(ConnectionStatus.DISCONNECTED);
        return true;
    }

    public boolean moveServo(ServoController.ServoId<OpenServo.Id> id, long lenMillisec) {
        OpenServo servo = (OpenServo)((Object)this.myServoMap.get(id));
        if (servo == null) {
            return true;
        }
        long goalTime = TimeUtils.now() + lenMillisec;
        Integer goalVal = servo.getAbsoluteGoalPosition();
        if (goalVal == null) {
            return true;
        }
        GoalUpdateValues<Object> goal = new GoalUpdateValues<Object>(id.getServoId(), goalVal, goalTime);
        this.myCache.setGoalPositions(Arrays.asList(goal));
        return true;
    }

    public boolean moveServos(ServoController.ServoId<OpenServo.Id>[] ids, int len, int offset, long lenMillisec) {
        boolean ret = true;
        for (int i = offset; i < offset + len; ++i) {
            ret = this.moveServo(ids[i], lenMillisec) && ret;
        }
        return ret;
    }

    public boolean moveAllServos(long lenMillisec) {
        ServoController.ServoId[] ids = this.myServoMap.keySet().toArray(new ServoController.ServoId[0]);
        return this.moveServos(ids, ids.length, 0, lenMillisec);
    }

    public List<String> getErrorMessages() {
        return Collections.EMPTY_LIST;
    }

    public void setEnabled(Boolean enabled) {
        this.myEnabledFlag = enabled;
    }

    public Boolean getEnabled() {
        return this.myEnabledFlag;
    }

    public Class<OpenServo.Id> getServoIdClass() {
        return OpenServo.Id.class;
    }

    public void configureServo(OpenServo.Id id, int pGain) {
        this.sendCommands(id, OpenServoCommandSet.Command.WRITE_ENABLE);
        this.writeRegisters(id, OpenServoCommandSet.Register.PULSE_CONTROL_ENABLED, 0);
        this.writeRegisterWords(id, OpenServoCommandSet.Register.PID_PGAIN_HI, pGain);
        this.sendCommands(id, OpenServoCommandSet.Command.REGISTERS_SAVE);
    }

    public void enableServo(OpenServo.Id id) {
        this.sendCommands(id, OpenServoCommandSet.Command.PWM_ENABLE);
    }

    public void disableServo(OpenServo.Id id) {
        this.sendCommands(id, OpenServoCommandSet.Command.PWM_DISABLE);
    }

    public void sendCommands(OpenServo.Id id, OpenServoCommandSet.Command ... cmds) {
        byte rs485Addr = (byte)id.getRS485Addr();
        byte i2cAddr = (byte)id.getI2CAddr();
        byte[] bytes = OpenServoCommandSet.sendCommands(rs485Addr, i2cAddr, cmds);
        DynamixelControlLoop.DynamixelCommand dcmd = new DynamixelControlLoop.DynamixelCommand(bytes, 0, 0, new DynamixelControlLoop.PacketCallback());
        this.myControlLoop.queueCommand(dcmd);
    }

    public void writeRegisters(OpenServo.Id id, OpenServoCommandSet.Register firstRegister, byte ... data) {
        byte rs485Addr = (byte)id.getRS485Addr();
        byte i2cAddr = (byte)id.getI2CAddr();
        byte[] bytes = OpenServoCommandSet.writeRegisters(rs485Addr, i2cAddr, firstRegister, data);
        DynamixelControlLoop.DynamixelCommand dcmd = new DynamixelControlLoop.DynamixelCommand(bytes, 0, 0, new DynamixelControlLoop.PacketCallback());
        this.myControlLoop.queueCommand(dcmd);
    }

    public void writeRegisterWords(OpenServo.Id id, OpenServoCommandSet.Register firstRegister, int ... data) {
        byte[] byteData = new byte[data.length * 2];
        for (int i = 0; i < data.length; ++i) {
            int val = data[i];
            byte hi = (byte)(val >> 8 & 0xFF);
            byte lo = (byte)(val & 0xFF);
            byteData[i * 2] = hi;
            byteData[i * 2 + 1] = lo;
        }
        byte rs485Addr = (byte)id.getRS485Addr();
        byte i2cAddr = (byte)id.getI2CAddr();
        byte[] bytes = OpenServoCommandSet.writeRegisters(rs485Addr, i2cAddr, firstRegister, byteData);
        DynamixelControlLoop.DynamixelCommand dcmd = new DynamixelControlLoop.DynamixelCommand(bytes, 0, 0, new DynamixelControlLoop.PacketCallback());
        this.myControlLoop.queueCommand(dcmd);
    }
}

