/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.motion.openservo.feedback;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.robokind.impl.motion.dynamixel.feedback.GoalUpdateValues;
import org.robokind.impl.motion.dynamixel.feedback.MoveParams;
import org.robokind.impl.motion.openservo.OpenServo;
import org.robokind.impl.motion.openservo.feedback.OpenServoCache;
import org.robokind.impl.motion.openservo.feedback.OpenServoFeedbackValues;

public class ConcurrentOpenServoCache {
    private Map<OpenServo.Id, OpenServoCache> myValueMap = new HashMap<OpenServo.Id, OpenServoCache>();
    private Map<OpenServo.Id, OpenServoFeedbackValues> myFeedbackQueue = new HashMap<OpenServo.Id, OpenServoFeedbackValues>();
    private Map<OpenServo.Id, GoalUpdateValues<OpenServo.Id>> myGoalParamQueue = new HashMap<OpenServo.Id, GoalUpdateValues<OpenServo.Id>>();
    private Lock myValueLock = new ReentrantLock();
    private boolean myMoveFlag = false;

    public synchronized Collection<MoveParams<OpenServo.Id>> acquireMoveParams() {
        this.myValueLock.lock();
        return this.myValueMap.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void releaseMoveParams() {
        try {
            this.mergeFeedback(this.myFeedbackQueue.values());
            this.mergeGoals(this.myGoalParamQueue.values());
            this.myFeedbackQueue.clear();
            this.myGoalParamQueue.clear();
        }
        finally {
            this.myValueLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addFeedbackValues(Collection<OpenServoFeedbackValues> values) {
        if (this.myValueLock.tryLock()) {
            try {
                this.mergeFeedback(values);
            }
            finally {
                this.myValueLock.unlock();
            }
        } else {
            this.queueFeedback(values);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setGoalPositions(Collection<GoalUpdateValues<OpenServo.Id>> goals) {
        if (this.myValueLock.tryLock()) {
            try {
                this.mergeGoals(goals);
            }
            finally {
                this.myValueLock.unlock();
            }
        } else {
            this.queueGoals(goals);
        }
    }

    private void queueFeedback(Collection<OpenServoFeedbackValues> vals) {
        for (OpenServoFeedbackValues val : vals) {
            if (val.getCurrentVoltage() == 0) continue;
            this.myFeedbackQueue.put(val.getServoId(), val);
        }
    }

    private void mergeFeedback(Collection<OpenServoFeedbackValues> vals) {
        for (OpenServoFeedbackValues val : vals) {
            OpenServo.Id id = val.getServoId();
            OpenServoCache cache = this.myValueMap.get(id);
            if (cache == null) {
                cache = new OpenServoCache(id);
                cache.setGoalVals(new GoalUpdateValues<OpenServo.Id>(id, -1, 0L));
                cache.goalsSent();
                this.myValueMap.put(id, cache);
            }
            cache.setFeedbackVals(val);
        }
    }

    private void queueGoals(Collection<GoalUpdateValues<OpenServo.Id>> vals) {
        for (GoalUpdateValues<OpenServo.Id> val : vals) {
            this.myGoalParamQueue.put(val.getServoId(), val);
        }
    }

    private void mergeGoals(Collection<GoalUpdateValues<OpenServo.Id>> goals) {
        for (GoalUpdateValues<OpenServo.Id> val : goals) {
            OpenServo.Id id = val.getServoId();
            OpenServoCache cache = this.myValueMap.get(id);
            if (cache == null) {
                cache = new OpenServoCache(id);
                cache.setFeedbackVals(new OpenServoFeedbackValues(id, new int[5], 0L));
                this.myValueMap.put(id, cache);
            }
            cache.setGoalVals(val);
        }
        if (!goals.isEmpty()) {
            this.setMoveFlag(true);
        }
    }

    public synchronized boolean getMoveFlag() {
        return this.myMoveFlag;
    }

    public synchronized void setMoveFlag(boolean val) {
        this.myMoveFlag = val;
    }

    public Map<OpenServo.Id, OpenServoCache> getValueMap() {
        return this.myValueMap;
    }
}

