/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.motion.openservo.utils;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.robokind.api.motion.servos.ServoController;
import org.robokind.api.motion.servos.utils.ServoIdReader;
import org.robokind.impl.motion.openservo.OpenServo;

public class OpenServoIdReader
implements ServoIdReader<OpenServo.Id> {
    private static final Logger theLogger = Logger.getLogger(OpenServoIdReader.class.getName());

    public ServoController.ServoId<OpenServo.Id> read(ServoController.Id controllerId, String servoIdStr) {
        if (controllerId == null || servoIdStr == null) {
            throw new NullPointerException();
        }
        OpenServo.Id dId = this.read(servoIdStr);
        return new ServoController.ServoId(controllerId, (Object)dId);
    }

    public OpenServo.Id read(String servoIdStr) {
        if (servoIdStr == null) {
            throw new NullPointerException();
        }
        int splitIndex = servoIdStr.indexOf("::");
        if (splitIndex < 0 || splitIndex >= servoIdStr.length() - 2) {
            throw new IllegalArgumentException();
        }
        String rs485Str = servoIdStr.substring(0, splitIndex).trim();
        String i2cStr = servoIdStr.substring(splitIndex + 2).trim();
        try {
            int rs485Id = Integer.parseInt(rs485Str);
            int i2cId = Integer.parseInt(i2cStr);
            return new OpenServo.Id(rs485Id, i2cId);
        }
        catch (NumberFormatException ex) {
            theLogger.log(Level.SEVERE, "Could not read OpenServo.Id", ex);
            throw ex;
        }
    }

    public Class<OpenServo.Id> getServoIdClass() {
        return OpenServo.Id.class;
    }
}

