/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.motion.dynamixel;

import java.util.HashMap;
import java.util.Map;
import org.robokind.api.common.position.NormalizedDouble;
import org.robokind.api.common.utils.HashCodeUtil;
import org.robokind.api.common.utils.LocalIdentifier;
import org.robokind.api.common.utils.TimeUtils;
import org.robokind.api.common.utils.Utils;
import org.robokind.api.motion.servos.AbstractServo;
import org.robokind.api.motion.servos.ServoController;
import org.robokind.api.motion.servos.config.ServoConfig;
import org.robokind.impl.motion.dynamixel.DynamixelController;
import org.robokind.impl.motion.dynamixel.enums.DynamixelBaudRate;
import org.robokind.impl.motion.dynamixel.enums.ErrorStatus;
import org.robokind.impl.motion.dynamixel.enums.Register;
import org.robokind.impl.motion.dynamixel.feedback.FeedbackUpdateValues;

public class DynamixelServo
extends AbstractServo<Id, ServoConfig<Id>, DynamixelController> {
    private final Map<Register, Integer> myCache;
    private Boolean myIsChanged;
    private Id myPhysicalId;
    private int myMinPosition;
    private int myMaxPosition;
    private int myPreviousPosition;
    private NormalizedDouble myDefaultPosition;
    private String myName;
    private FeedbackUpdateValues myFeedbackUpdateVals;

    public DynamixelServo(ServoConfig<Id> params, DynamixelController controller) {
        super(params, (ServoController)controller);
        this.myPhysicalId = (Id)params.getServoId();
        this.myIsChanged = false;
        this.myCache = new HashMap<Register, Integer>();
        int[] vals = ((DynamixelController)this.myController).readRegisters(this.getPhysicalId(), Register.CurrentPosition, Register.CurrentTemperature);
        this.myFeedbackUpdateVals = new FeedbackUpdateValues(this.myPhysicalId, vals, TimeUtils.now());
        this.myPreviousPosition = vals[0];
        this.myCache.put(Register.GoalPosition, vals[0]);
        this.myMinPosition = params.getMinPosition();
        this.myMaxPosition = params.getMaxPosition();
        double defInt = params.getDefaultPosition() - this.myMinPosition;
        double range = this.myMaxPosition - this.myMinPosition;
        double val = defInt / range;
        if (!NormalizedDouble.isValid((double)val)) {
            throw new IllegalArgumentException("Default Position invalid: " + params.getDefaultPosition());
        }
        this.myDefaultPosition = new NormalizedDouble(val);
        this.myName = params.getName();
    }

    public final Id getPhysicalId() {
        return this.myPhysicalId;
    }

    public void setEnabled(Boolean enabled) {
        Boolean old = this.getEnabled();
        this.setTorqueEnabled(enabled);
        this.firePropertyChange("enabled", old, enabled);
    }

    public Boolean getEnabled() {
        return this.getTorqueEnable();
    }

    public String getName() {
        return this.myName;
    }

    public int getMinPosition() {
        return this.myMinPosition;
    }

    public int getMaxPosition() {
        return this.myMaxPosition;
    }

    protected int getPreviousPosition() {
        return this.myPreviousPosition;
    }

    protected void setPreviousPosition(int pos) {
        this.myPreviousPosition = pos;
    }

    public NormalizedDouble getDefaultPosition() {
        return this.myDefaultPosition;
    }

    public Integer get(Register reg) {
        if (!this.myCache.containsKey((Object)reg)) {
            return -1;
        }
        return this.myCache.get((Object)reg);
    }

    protected void put(Register reg, Integer value) {
        this.myCache.put(reg, value);
    }

    public void setGoalPosition(NormalizedDouble value) {
        super.setGoalPosition(value);
        Integer goal = this.getAbsoluteGoalPosition();
        if (goal == null) {
            return;
        }
        this.SetRegisterValue(Register.GoalPosition, goal);
    }

    public Integer getMovingSpeed() {
        return this.GetRegisterValue(Register.MovingSpeed);
    }

    public void setMovingSpeed(Integer value) {
        this.SetRegisterValue(Register.MovingSpeed, value);
    }

    public ErrorStatus getAlarmLed() {
        return ErrorStatus.getStatus(this.GetRegisterValue(Register.AlarmLed));
    }

    public void setAlarmLed(ErrorStatus value) {
        this.SetRegisterValue(Register.AlarmLed, (int)value.getByte());
    }

    public ErrorStatus getAlarmShutdown() {
        return ErrorStatus.getStatus(this.GetRegisterValue(Register.AlarmShutdown));
    }

    public void setAlarmShutdown(ErrorStatus value) {
        this.SetRegisterValue(Register.AlarmShutdown, (int)value.getByte());
    }

    public DynamixelBaudRate getBaudRate() {
        return DynamixelBaudRate.get((byte)this.GetRegisterValue(Register.BaudRate).intValue());
    }

    public void setBaudRate(DynamixelBaudRate value) {
        this.SetRegisterValue(Register.BaudRate, (int)value.getByte());
    }

    public Integer getCcwAngleLimit() {
        return this.GetRegisterValue(Register.CcwAngleLimit);
    }

    public void setCcwAngleLimit(Integer value) {
        this.SetRegisterValue(Register.CcwAngleLimit, value);
    }

    public Integer getCwAngleLimit() {
        return this.GetRegisterValue(Register.CwAngleLimit);
    }

    public void setCwAngleLimit(Integer value) {
        this.SetRegisterValue(Register.CwAngleLimit, value);
    }

    public Integer getCcwComplianceMargin() {
        return this.GetRegisterValue(Register.CcwComplianceMargin);
    }

    public void setCcwComplianceMargin(Integer value) {
        this.SetRegisterValue(Register.CcwComplianceMargin, value);
    }

    public Integer getCwComplianceMargin() {
        return this.GetRegisterValue(Register.CwComplianceMargin);
    }

    public void setCwComplianceMargin(Integer value) {
        this.SetRegisterValue(Register.CwComplianceMargin, value);
    }

    public Integer getCcwComplianceSlope() {
        return this.GetRegisterValue(Register.CcwComplianceSlope);
    }

    public void setCcwComplianceSlope(Integer value) {
        this.SetRegisterValue(Register.CcwComplianceSlope, value);
    }

    public Integer getCwComplianceSlope() {
        return this.GetRegisterValue(Register.CwComplianceSlope);
    }

    public void setCwComplianceSlope(Integer value) {
        this.SetRegisterValue(Register.CwComplianceSlope, value);
    }

    public Integer getCurrentLoad() {
        return this.myFeedbackUpdateVals.getCurrentLoad();
    }

    public NormalizedDouble getCurrentPosition() {
        double min = this.myConfig.getMinPosition();
        double max = this.myConfig.getMaxPosition();
        Double range = max - min;
        Double abs = (double)this.getCurrentPositionAbs().intValue() - min;
        Double pos = Utils.bound((double)(abs / range), (double)0.0, (double)1.0);
        return new NormalizedDouble(pos.doubleValue());
    }

    public Integer getCurrentPositionAbs() {
        return this.myFeedbackUpdateVals.getCurrentPosition();
    }

    public Integer getCurrentSpeed() {
        return this.myFeedbackUpdateVals.getCurrentSpeed();
    }

    public Integer getCurrentTemperature() {
        return this.myFeedbackUpdateVals.getCurrentTemperature();
    }

    public Integer getCurrentVoltage() {
        return this.myFeedbackUpdateVals.getCurrentVoltage();
    }

    public Boolean getTorqueEnable() {
        return this.GetRegisterValue(Register.TorqueEnable) != 0;
    }

    public void setTorqueEnabled(Boolean value) {
        this.SetRegisterValue(Register.TorqueEnable, value != false ? 1 : 0);
    }

    public Integer getFirmwareVersion() {
        return this.GetRegisterValue(Register.FirmwareVersion);
    }

    public Boolean getLed() {
        return this.GetRegisterValue(Register.Led) != 0;
    }

    public void setLed(Boolean value) {
        this.SetRegisterValue(Register.Led, value != false ? 1 : 0);
    }

    public Boolean getLock() {
        return this.GetRegisterValue(Register.Lock) != 0;
    }

    public Integer getTemperatureLimit() {
        return this.GetRegisterValue(Register.TemperatureLimit);
    }

    public void setTemperatureLimit(Integer value) {
        this.SetRegisterValue(Register.TemperatureLimit, value);
    }

    public Integer getMaxTorque() {
        return this.GetRegisterValue(Register.MaxTorque);
    }

    public void setMaxTorque(Integer value) {
        this.SetRegisterValue(Register.MaxTorque, value);
    }

    public float getHighVoltageLimit() {
        return (float)((double)this.GetRegisterValue(Register.HighVoltageLimit).intValue() / 10.0);
    }

    public void setHighVoltageLimit(float value) {
        this.SetRegisterValue(Register.HighVoltageLimit, (int)Math.round((double)value * 10.0));
    }

    public float getLowVoltageLimit() {
        return (float)((double)this.GetRegisterValue(Register.LowVoltageLimit).intValue() / 10.0);
    }

    public void setLowVoltageLimit(float value) {
        this.SetRegisterValue(Register.LowVoltageLimit, (int)Math.round((double)value * 10.0));
    }

    public Integer getModelNumber() {
        return this.GetRegisterValue(Register.ModelNumber);
    }

    public Boolean getMoving() {
        return this.myIsChanged != false || ((DynamixelController)this.myController).readRegister(this.getPhysicalId(), Register.Moving) != 0;
    }

    public Integer getPunch() {
        return this.GetRegisterValue(Register.Punch);
    }

    public void setPunch(Integer value) {
        this.SetRegisterValue(Register.Punch, value);
    }

    public Boolean getRegisteredInstruction() {
        return ((DynamixelController)this.myController).readRegister(this.getPhysicalId(), Register.RegisteredInstruction) != 0;
    }

    public void setRegisteredInstruction(Boolean value) {
        this.SetRegisterValue(Register.RegisteredInstruction, value != false ? 1 : 0);
    }

    public Integer getReturnDelay() {
        return this.GetRegisterValue(Register.ReturnDelay) * 2;
    }

    public void setReturnDelay(Integer value) {
        this.SetRegisterValue(Register.ReturnDelay, value / 2);
    }

    public Integer getStatusReturnLevel() {
        return this.GetRegisterValue(Register.StatusReturnLevel);
    }

    public void setStatusReturnLevel(Integer value) {
        this.SetRegisterValue(Register.StatusReturnLevel, value);
    }

    public Integer getTorqueLimit() {
        return this.GetRegisterValue(Register.TorqueLimit);
    }

    public void setTorqueLimit(Integer value) {
        this.SetRegisterValue(Register.TorqueLimit, value);
    }

    protected synchronized boolean reset() {
        return false;
    }

    protected Integer GetRegisterValue(Register reg) {
        switch (reg) {
            case GoalPosition: 
            case MovingSpeed: {
                return this.get(reg);
            }
        }
        if (!reg.isCached()) {
            return ((DynamixelController)this.myController).readRegister(this.getPhysicalId(), reg);
        }
        Integer v = this.get(reg);
        if (v == -1) {
            this.put(reg, ((DynamixelController)this.myController).readRegister(this.getPhysicalId(), reg));
            v = this.get(reg);
        }
        return v;
    }

    protected synchronized void SetRegisterValue(Register reg, Integer value) {
        if (reg.isSynchronized()) {
            this.put(reg, value);
            this.myIsChanged = true;
            return;
        }
        if (!reg.isCached()) {
            ((DynamixelController)this.myController).writeRegister(this.getPhysicalId(), reg, value, false);
            return;
        }
        Integer v = this.get(reg);
        if (v == value) {
            return;
        }
        ((DynamixelController)this.myController).writeRegister(this.getPhysicalId(), reg, value, false);
        this.put(reg, value);
    }

    public synchronized void cacheValues() {
        Register[] regs = Register.values();
        int[] values = ((DynamixelController)this.myController).readRegisters(this.getPhysicalId(), Register.ModelNumber, Register.Punch);
        Integer i = 0;
        while (i < regs.length) {
            this.put(regs[i], values[i]);
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
    }

    public boolean changed() {
        return this.myIsChanged;
    }

    public void setFeedbackVals(FeedbackUpdateValues vals) {
        if (vals == null) {
            return;
        }
        this.myFeedbackUpdateVals = vals;
    }

    public static final class Id
    implements LocalIdentifier {
        private static final int theIdCount = 254;
        private int myPhysicalJointId;

        Id() {
            this.myPhysicalJointId = 254;
        }

        public Id(int id) {
            if (!Id.isValidId(id)) {
                throw new IllegalArgumentException("PhysicalId out of range.");
            }
            this.myPhysicalJointId = id;
        }

        public final int getIntValue() {
            return this.myPhysicalJointId;
        }

        public boolean equals(Object obj) {
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            return this.myPhysicalJointId == ((Id)obj).myPhysicalJointId;
        }

        public static boolean isValidId(int id) {
            return id >= 0 && id < 254;
        }

        public int hashCode() {
            return HashCodeUtil.hash((int)23, (int)this.myPhysicalJointId);
        }

        public String toString() {
            return "" + this.myPhysicalJointId;
        }
    }
}

