/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.motion.dynamixel.osgi;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.robokind.api.common.services.ConfigurationLoader;
import org.robokind.api.common.services.ServiceFactory;
import org.robokind.api.common.services.ServiceUtils;
import org.robokind.api.motion.servos.utils.ServoIdReader;
import org.robokind.api.motion.servos.utils.ServoJointAdapter;
import org.robokind.impl.motion.dynamixel.DynamixelConnector;
import org.robokind.impl.motion.dynamixel.DynamixelController;
import org.robokind.impl.motion.dynamixel.utils.DynamixelControllerConfig;
import org.robokind.impl.motion.dynamixel.utils.DynamixelJointAdapter;
import org.robokind.impl.motion.dynamixel.utils.DynamixelServoIdReader;
import org.robokind.impl.motion.openservo.OpenServoConnector;
import org.robokind.impl.motion.openservo.OpenServoController;
import org.robokind.impl.motion.openservo.utils.OpenServoControllerConfig;
import org.robokind.impl.motion.openservo.utils.OpenServoIdReader;
import org.robokind.impl.motion.openservo.utils.OpenServoJointAdapter;

public class Activator
implements BundleActivator {
    private static final Logger theLogger = Logger.getLogger(Activator.class.getName());

    public void start(BundleContext context) throws Exception {
        theLogger.log(Level.INFO, "DynamixelServoBundle Activation Begin.");
        ServiceUtils.registerFactory((BundleContext)context, (ServiceFactory)new DynamixelConnector());
        ServiceUtils.registerConfigLoader((BundleContext)context, (ConfigurationLoader)new DynamixelControllerConfig.Reader());
        this.registerServoJointAdapter(context);
        this.registerServoIdReader(context);
        ServiceUtils.registerFactory((BundleContext)context, (ServiceFactory)new OpenServoConnector());
        ServiceUtils.registerConfigLoader((BundleContext)context, (ConfigurationLoader)new OpenServoControllerConfig.Reader());
        this.registerOpenServoJointAdapter(context);
        this.registerOpenServoIdReader(context);
        theLogger.log(Level.INFO, "DynamixelServoBundle Activation Complete.");
    }

    private void registerServoJointAdapter(BundleContext context) {
        DynamixelJointAdapter adapter = new DynamixelJointAdapter();
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("ServiceVersion", DynamixelController.VERSION.toString());
        context.registerService(ServoJointAdapter.class.getName(), (Object)adapter, props);
        theLogger.log(Level.INFO, "DynamixelJointAdapter Service Registered Successfully.");
    }

    private void registerServoIdReader(BundleContext context) {
        DynamixelServoIdReader reader = new DynamixelServoIdReader();
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("ServiceVersion", DynamixelController.VERSION.toString());
        context.registerService(ServoIdReader.class.getName(), (Object)reader, props);
        theLogger.log(Level.INFO, "DynamixelServoIdReader Service Registered Successfully.");
    }

    private void registerOpenServoJointAdapter(BundleContext context) {
        OpenServoJointAdapter adapter = new OpenServoJointAdapter();
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("ServiceVersion", OpenServoController.VERSION.toString());
        context.registerService(ServoJointAdapter.class.getName(), (Object)adapter, props);
        theLogger.log(Level.INFO, "OpenServoJointAdapter Service Registered Successfully.");
    }

    private void registerOpenServoIdReader(BundleContext context) {
        OpenServoIdReader reader = new OpenServoIdReader();
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("ServiceVersion", OpenServoController.VERSION.toString());
        context.registerService(ServoIdReader.class.getName(), (Object)reader, props);
        theLogger.log(Level.INFO, "OpenServoIdReader Service Registered Successfully.");
    }

    public void stop(BundleContext context) throws Exception {
    }
}

