/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.motion.dynamixel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.robokind.api.common.config.VersionProperty;
import org.robokind.api.common.position.NormalizedDouble;
import org.robokind.api.common.utils.TimeUtils;
import org.robokind.api.motion.servos.ServoController;
import org.robokind.api.motion.servos.config.ServoConfig;
import org.robokind.impl.motion.dynamixel.DynamixelCommandSender;
import org.robokind.impl.motion.dynamixel.DynamixelServo;
import org.robokind.impl.motion.dynamixel.enums.Register;
import org.robokind.impl.motion.dynamixel.feedback.DynamixelControlLoop;
import org.robokind.impl.motion.dynamixel.feedback.DynamixelControlSettings;
import org.robokind.impl.motion.dynamixel.feedback.GoalUpdateValues;
import org.robokind.impl.motion.dynamixel.utils.DynamixelControllerConfig;
import org.robokind.impl.motion.rxtx.serial.RXTXSerialPort;
import org.robokind.impl.motion.rxtx.serial.SerialServoController;
import org.robokind.impl.motion.serial.SerialServoControllerConfig;

public class DynamixelController
extends SerialServoController<DynamixelServo.Id, ServoConfig<DynamixelServo.Id>, DynamixelServo, DynamixelControllerConfig> {
    private static final Logger theLogger = Logger.getLogger(DynamixelController.class.getName());
    public static final String VERSION_NAME = "Dynamixel RX";
    public static final String VERSION_NUMBER = "1.0";
    public static final VersionProperty VERSION = new VersionProperty("Dynamixel RX", "1.0");
    public static final DynamixelServo.Id BROADCAST_ID = new DynamixelServo.Id();
    private Map<DynamixelServo.Id, ServoConfig> myUnresponsiveServos;
    private Boolean myEnabledFlag;
    private DynamixelControlLoop myControlLoop;

    public DynamixelController(DynamixelControllerConfig config) {
        super((SerialServoControllerConfig)config);
        DynamixelControlSettings settings = new DynamixelControlSettings(1, 0, 77.0, 69.0, 0.0, 30);
        this.setTimeoutLength(settings.getTimeoutLengthMillisec());
        this.myControlLoop = new DynamixelControlLoop(this, settings);
        this.myEnabledFlag = false;
    }

    protected synchronized boolean setServos() {
        this.myServos.clear();
        this.myServoMap.clear();
        this.myUnresponsiveServos = new HashMap<DynamixelServo.Id, ServoConfig>();
        for (ServoConfig param : ((DynamixelControllerConfig)this.myConfig).getServoConfigs().values()) {
            DynamixelServo.Id id = (DynamixelServo.Id)param.getServoId();
            if (!this.ping(id)) {
                this.myUnresponsiveServos.put((DynamixelServo.Id)param.getServoId(), param);
                theLogger.log(Level.WARNING, "Unable to ping Dynamixel {0}.", new Object[]{param.getServoId()});
                continue;
            }
            DynamixelServo servo = new DynamixelServo((ServoConfig<DynamixelServo.Id>)param, this);
            this.myServos.add(servo);
            DynamixelServo.Id sId = (DynamixelServo.Id)servo.getId();
            ServoController.ServoId servoId = new ServoController.ServoId(this.getId(), (Object)sId);
            this.myServoMap.put(servoId, servo);
            this.initServo(servo);
        }
        return true;
    }

    private void initServo(DynamixelServo servo) {
        servo.setEnabled(this.myEnabledFlag);
        NormalizedDouble def = servo.getDefaultPosition();
        servo.setGoalPosition(def);
    }

    public boolean moveServo(ServoController.ServoId<DynamixelServo.Id> id, long lenMillisec) {
        return this.moveServos(new ServoController.ServoId[]{id}, 1, 0, lenMillisec);
    }

    public boolean moveServos(ServoController.ServoId<DynamixelServo.Id>[] ids, int len, int offset, long lenMillisec) {
        ArrayList<GoalUpdateValues<DynamixelServo.Id>> goals = new ArrayList<GoalUpdateValues<DynamixelServo.Id>>(len);
        long goalTime = TimeUtils.now() + lenMillisec;
        for (int i = offset; i < offset + len; ++i) {
            Integer goalVal;
            ServoController.ServoId<DynamixelServo.Id> id = ids[i];
            DynamixelServo servo = (DynamixelServo)((Object)this.myServoMap.get(id));
            if (servo == null || (goalVal = servo.getAbsoluteGoalPosition()) == null) continue;
            GoalUpdateValues<Object> goal = new GoalUpdateValues<Object>(id.getServoId(), goalVal, goalTime);
            goals.add(goal);
        }
        this.myControlLoop.setGoalPositions(goals);
        return true;
    }

    public boolean moveAllServos(long lenMillisec) {
        ServoController.ServoId[] ids = this.myServoMap.keySet().toArray(new ServoController.ServoId[0]);
        return this.moveServos(ids, ids.length, 0, lenMillisec);
    }

    public synchronized boolean ping(DynamixelServo.Id id) {
        return DynamixelCommandSender.ping(this.myControlLoop, id, this.myTimeoutLength);
    }

    public int readRegister(DynamixelServo.Id id, Register reg) {
        int[] vals = this.readRegisters(id, reg, reg);
        if (vals == null || vals.length == 0) {
            return 0;
        }
        return vals[0];
    }

    public synchronized int[] readRegisters(DynamixelServo.Id id, Register regFirst, Register regLast) {
        return DynamixelCommandSender.readRegisters(this.myControlLoop, id, regFirst, regLast, this.myTimeoutLength);
    }

    protected boolean writeRegister(DynamixelServo.Id id, Register reg, Integer value, Boolean deferred) {
        return DynamixelCommandSender.writeRegister(this.myControlLoop, id, reg, value, this.myTimeoutLength);
    }

    protected DynamixelServo connectServo(ServoConfig config) {
        return new DynamixelServo((ServoConfig<DynamixelServo.Id>)config, this);
    }

    protected boolean disconnectServo(ServoController.ServoId<DynamixelServo.Id> id) {
        return true;
    }

    public void setEnabled(Boolean enabled) {
        Boolean old = this.myEnabledFlag;
        this.myEnabledFlag = enabled;
        for (DynamixelServo servo : this.myServos) {
            servo.setEnabled(enabled);
        }
        this.firePropertyChange("enabled", old, enabled);
    }

    public Boolean getEnabled() {
        return this.myEnabledFlag;
    }

    public boolean connect() {
        boolean connect = super.connect();
        if (connect) {
            this.setServos();
            ArrayList<DynamixelServo.Id> ids = new ArrayList<DynamixelServo.Id>();
            for (DynamixelServo servo : this.myServos) {
                ids.add((DynamixelServo.Id)servo.getId());
            }
            this.myControlLoop.start(ids);
            ServoController.ServoId[] servoIdArray = this.myServoMap.keySet().toArray(new ServoController.ServoId[0]);
        }
        return connect;
    }

    public boolean disconnect() {
        if (this.myControlLoop != null) {
            this.myControlLoop.stop();
        }
        return super.disconnect();
    }

    public Class<DynamixelServo.Id> getServoIdClass() {
        return DynamixelServo.Id.class;
    }

    public RXTXSerialPort getPort() {
        return this.myPort;
    }

    public DynamixelControlLoop getControlLoop() {
        return this.myControlLoop;
    }
}

