/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.motion.openservo;

import org.jflux.impl.services.rk.utils.LocalIdentifier;
import org.robokind.api.common.position.NormalizedDouble;
import org.robokind.api.common.utils.Utils;
import org.robokind.api.motion.servos.AbstractServo;
import org.robokind.api.motion.servos.ServoController;
import org.robokind.api.motion.servos.config.ServoConfig;
import org.robokind.impl.motion.openservo.OpenServoController;
import org.robokind.impl.motion.openservo.feedback.OpenServoFeedbackValues;

public class OpenServo
extends AbstractServo<Id, ServoConfig<Id>, OpenServoController> {
    private NormalizedDouble myDefaultPosition;
    private boolean myEnabledFlag = false;
    private OpenServoFeedbackValues myFeedbackVals;

    public OpenServo(ServoConfig<Id> config, OpenServoController controller) {
        super(config, (ServoController)controller);
        double range = this.myConfig.getMaxPosition() - this.myConfig.getMinPosition();
        double defVal = this.myConfig.getDefaultPosition() - this.myConfig.getMinPosition();
        double def = defVal / range;
        this.myDefaultPosition = new NormalizedDouble(def);
    }

    public void setFeedbackVals(OpenServoFeedbackValues vals) {
        this.myFeedbackVals = vals;
    }

    public NormalizedDouble getCurrentPosition() {
        if (this.myFeedbackVals == null) {
            return this.myDefaultPosition;
        }
        double min = this.myConfig.getMinPosition();
        double max = this.myConfig.getMaxPosition();
        Double range = max - min;
        Double abs = (double)this.myFeedbackVals.getCurrentPosition() - min;
        Double pos = Utils.bound((double)(abs / range), (double)0.0, (double)1.0);
        return new NormalizedDouble(pos.doubleValue());
    }

    public Integer getCurrentLoad() {
        if (this.myFeedbackVals == null) {
            return 0;
        }
        return this.myFeedbackVals.getCurrentLoad();
    }

    public Integer getCurrentVoltage() {
        if (this.myFeedbackVals == null) {
            return 0;
        }
        return this.myFeedbackVals.getCurrentVoltage();
    }

    public Boolean getEnabled() {
        return this.myEnabledFlag;
    }

    public void setEnabled(Boolean enabled) {
        if (this.setPWMEnabledRegister(enabled)) {
            this.myEnabledFlag = enabled;
        }
    }

    private boolean setPWMEnabledRegister(Boolean enabled) {
        if (enabled.booleanValue()) {
            ((OpenServoController)this.myController).enableServo((Id)this.getId());
        } else {
            ((OpenServoController)this.myController).disableServo((Id)this.getId());
        }
        return true;
    }

    public String getName() {
        return this.myConfig.getName();
    }

    public int getMinPosition() {
        return this.myConfig.getMinPosition();
    }

    public int getMaxPosition() {
        return this.myConfig.getMaxPosition();
    }

    public NormalizedDouble getDefaultPosition() {
        return this.myDefaultPosition;
    }

    public static final class Id
    implements LocalIdentifier {
        public static final int MAX_RS485_ADDR = 254;
        public static final int MAX_I2C_ADDR = 127;
        private int myRS485Addr;
        private int myI2CAddr;

        public Id(int rs485Addr, int i2cAddr) {
            if (!Id.isValidId(rs485Addr, i2cAddr)) {
                throw new IllegalArgumentException("PhysicalId out of range.");
            }
            this.myRS485Addr = rs485Addr;
            this.myI2CAddr = i2cAddr;
        }

        public int getRS485Addr() {
            return this.myRS485Addr;
        }

        public int getI2CAddr() {
            return this.myI2CAddr;
        }

        public boolean equals(Object obj) {
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            return this.myRS485Addr == ((Id)obj).myRS485Addr && this.myI2CAddr == ((Id)obj).myI2CAddr;
        }

        public static boolean isValidId(int rs485Addr, int i2cAddr) {
            return rs485Addr >= 0 && rs485Addr < 254 && i2cAddr >= 0 && i2cAddr < 127;
        }

        public int hashCode() {
            int hash = 7;
            hash = 71 * hash + this.myRS485Addr;
            hash = 71 * hash + this.myI2CAddr;
            return hash;
        }

        public String toString() {
            return "" + this.myRS485Addr + "::" + this.myI2CAddr;
        }
    }
}

