/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.motion.openservo.properties;

import org.robokind.api.common.position.DoubleRange;
import org.robokind.api.common.position.NormalizableRange;
import org.robokind.api.common.position.NormalizedDouble;
import org.robokind.api.common.types.Voltage;
import org.robokind.api.motion.joint_properties.ReadVoltage;
import org.robokind.impl.motion.openservo.OpenServo;

public class VoltageProperty
extends ReadVoltage {
    private OpenServo myServo;
    protected Voltage myCachedValue;

    public VoltageProperty(OpenServo servo) {
        if (servo == null) {
            throw new NullPointerException();
        }
        this.myServo = servo;
    }

    public Voltage getValue() {
        Voltage old = this.myCachedValue;
        this.myCachedValue = this.readValue();
        this.firePropertyChange(this.getPropertyName(), old, this.myCachedValue);
        return this.myCachedValue;
    }

    private Voltage readValue() {
        Integer dynaVoltage = this.myServo.getCurrentVoltage();
        if (dynaVoltage != null) {
            double volts = (double)dynaVoltage.intValue() / 10.0;
            return new Voltage(volts);
        }
        return null;
    }

    public NormalizableRange<Voltage> getNormalizableRange() {
        return new NormalizableRange<Voltage>(){
            private DoubleRange myDoubleRange = new DoubleRange(0.0, 1000.0);

            public boolean isValid(Voltage t) {
                return this.myDoubleRange.isValid(Double.valueOf(t.getVolts()));
            }

            public NormalizedDouble normalizeValue(Voltage t) {
                return this.myDoubleRange.normalizeValue(Double.valueOf(t.getVolts()));
            }

            public Voltage denormalizeValue(NormalizedDouble v) {
                return new Voltage(this.myDoubleRange.denormalizeValue(v).doubleValue());
            }

            public Voltage getMin() {
                return new Voltage(this.myDoubleRange.getMin().doubleValue());
            }

            public Voltage getMax() {
                return new Voltage(this.myDoubleRange.getMax().doubleValue());
            }
        };
    }
}

