/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.motion.pololu.osgi;

import java.util.Dictionary;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.robokind.api.common.services.ServiceConfigurationLoader;
import org.robokind.api.common.services.ServiceFactory;
import org.robokind.api.motion.servos.ServoController;
import org.robokind.api.motion.servos.utils.ServoIdReader;
import org.robokind.api.motion.servos.utils.ServoJointAdapter;
import org.robokind.impl.motion.pololu.MaestroConnector;
import org.robokind.impl.motion.pololu.MaestroController;
import org.robokind.impl.motion.pololu.MaestroControllerConfig;
import org.robokind.impl.motion.pololu.MaestroJointAdapter;
import org.robokind.impl.motion.pololu.MaestroServoIdReader;

public class Activator
implements BundleActivator {
    private static final Logger theLogger = Logger.getLogger(Activator.class.getName());

    public void start(BundleContext context) throws Exception {
        theLogger.log(Level.INFO, "PololuServoBundle Activation Begin.");
        this.registerMaestroConnector(context);
        this.registerServoJointAdapter(context);
        this.registerServoIdReader(context);
        this.registerMaestroConfigLoader(context);
        theLogger.log(Level.INFO, "PololuServoBundle Activation Complete.");
    }

    private void registerMaestroConnector(BundleContext context) {
        MaestroConnector connector = new MaestroConnector();
        Properties props = new Properties();
        props.put("ServiceVersion", MaestroController.VERSION.toString());
        props.put("ServiceClass", ServoController.class.getName());
        context.registerService(ServiceFactory.class.getName(), (Object)connector, (Dictionary)props);
        theLogger.log(Level.INFO, "MaestroConnector Service Registered Successfully.");
    }

    private void registerServoJointAdapter(BundleContext context) {
        MaestroJointAdapter adapter = new MaestroJointAdapter();
        Properties props = new Properties();
        props.put("servoControllerVersion", MaestroController.VERSION.toString());
        context.registerService(ServoJointAdapter.class.getName(), (Object)adapter, (Dictionary)props);
        theLogger.log(Level.INFO, "MaestroJointAdapter Service Registered Successfully.");
    }

    private void registerServoIdReader(BundleContext context) {
        MaestroServoIdReader reader = new MaestroServoIdReader();
        Properties props = new Properties();
        props.put("servoControllerVersion", MaestroController.VERSION.toString());
        context.registerService(ServoIdReader.class.getName(), (Object)reader, (Dictionary)props);
        theLogger.log(Level.INFO, "MaestroServoIdReader Service Registered Successfully.");
    }

    private void registerMaestroConfigLoader(BundleContext context) {
        MaestroControllerConfig.Reader reader = new MaestroControllerConfig.Reader();
        Properties props = new Properties();
        props.put("ConfigurationFormatVersion", MaestroControllerConfig.Reader.VERSION.toString());
        props.put("ServiceConfigurationClass", MaestroControllerConfig.class.getName());
        props.put("ServiceConfigParameterClass", HierarchicalConfiguration.class.getName());
        context.registerService(ServiceConfigurationLoader.class.getName(), (Object)reader, (Dictionary)props);
        theLogger.log(Level.INFO, "SerialServoControllerConfig XML Reader");
    }

    public void stop(BundleContext context) throws Exception {
    }
}

