/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.motion.pololu;

import org.robokind.api.common.position.NormalizedDouble;
import org.robokind.api.common.utils.HashCodeUtil;
import org.robokind.api.common.utils.LocalIdentifier;
import org.robokind.api.motion.servos.AbstractServo;
import org.robokind.api.motion.servos.ServoController;
import org.robokind.api.motion.servos.config.ServoConfig;
import org.robokind.impl.motion.pololu.MaestroController;

public class MaestroServo
extends AbstractServo<Id, ServoConfig<Id>, MaestroController> {
    private Id myPhysicalId = (Id)this.myConfig.getServoId();
    private Boolean myEnabledFlag = true;
    private int myMinPosition;
    private int myMaxPosition;
    private NormalizedDouble myDefaultPosition;
    private String myName;

    protected MaestroServo(ServoConfig<Id> params, MaestroController controller) {
        super(params, (ServoController)controller);
        this.myMinPosition = params.getMinPosition();
        this.myMaxPosition = params.getMaxPosition();
        double defInt = params.getDefaultPosition() - this.myMinPosition;
        double range = this.myMaxPosition - this.myMinPosition;
        double val = defInt / range;
        if (!NormalizedDouble.isValid((double)val)) {
            throw new IllegalArgumentException("Default Position invalid: " + params.getDefaultPosition());
        }
        this.myDefaultPosition = new NormalizedDouble(val);
        this.myName = params.getName();
        this.myGoalPosition = this.myDefaultPosition;
    }

    public Id getPhysicalId() {
        return this.myPhysicalId;
    }

    public void setEnabled(Boolean enabled) {
        Boolean old = this.myEnabledFlag;
        this.myEnabledFlag = enabled;
        this.firePropertyChange("enabled", old, enabled);
    }

    public Boolean getEnabled() {
        return this.myEnabledFlag;
    }

    public String getName() {
        return this.myName;
    }

    public int getMinPosition() {
        return this.myMinPosition;
    }

    public int getMaxPosition() {
        return this.myMaxPosition;
    }

    public NormalizedDouble getDefaultPosition() {
        return this.myDefaultPosition;
    }

    public static final class Id
    implements LocalIdentifier,
    Comparable {
        private static final int theIdCount = 12;
        private byte myServoNumber;

        Id(byte num) {
            if (!Id.isValidId(num)) {
                throw new IllegalArgumentException("PhysicalId out of range.");
            }
            this.myServoNumber = num;
        }

        final byte getServoNumber() {
            return this.myServoNumber;
        }

        public boolean equals(Object obj) {
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            return this.myServoNumber == ((Id)obj).myServoNumber;
        }

        boolean isConsecutive(Id id) {
            return id != null && this.myServoNumber + 1 == id.myServoNumber;
        }

        Id getOffsetId(byte offset) {
            int id = this.myServoNumber + offset;
            if (!Id.isValidId(id)) {
                return null;
            }
            return new Id((byte)id);
        }

        public static boolean isValidId(int id) {
            return id >= 0 && id < 12;
        }

        public int hashCode() {
            return HashCodeUtil.hash((int)23, (int)this.myServoNumber);
        }

        public String toString() {
            return "" + this.myServoNumber;
        }

        public int compareTo(Object o) {
            Byte b;
            if (o == null || !Id.class.isAssignableFrom(o.getClass())) {
                return 1;
            }
            Byte a = this.myServoNumber;
            int compare = a.compareTo(b = Byte.valueOf(((Id)o).myServoNumber));
            if (compare == 0 && o.getClass() != this.getClass()) {
                return 1;
            }
            return compare;
        }
    }
}

