/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.motion.pololu;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.robokind.api.common.config.VersionProperty;
import org.robokind.api.motion.servos.ServoController;
import org.robokind.api.motion.servos.config.ServoConfig;
import org.robokind.api.motion.servos.utils.ConnectionStatus;
import org.robokind.impl.motion.pololu.MaestroControllerConfig;
import org.robokind.impl.motion.pololu.MaestroServo;
import org.robokind.impl.motion.serial.SerialServoController;
import org.robokind.impl.motion.serial.SerialServoControllerConfig;

public class MaestroController
extends SerialServoController<MaestroServo.Id, ServoConfig<MaestroServo.Id>, MaestroServo, MaestroControllerConfig> {
    public static final String VERSION_NAME = "Pololu Mini Maestro";
    public static final String VERSION_NUMBER = "1.0";
    public static final VersionProperty VERSION = new VersionProperty("Pololu Mini Maestro", "1.0");
    private static final Logger theLogger = Logger.getLogger(MaestroController.class.getName());
    private Map<MaestroServo.Id, MaestroServo> myPhysicalMap = new HashMap<MaestroServo.Id, MaestroServo>();
    private Boolean myEnabledFlag = true;

    public MaestroController(MaestroControllerConfig config) {
        super((SerialServoControllerConfig)config);
    }

    public boolean connect() {
        boolean connect = super.connect();
        if (connect) {
            this.setServos();
            ServoController.ServoId[] sIds = this.myServoMap.keySet().toArray(new ServoController.ServoId[0]);
            this.moveServos(sIds, sIds.length, 0, 3000L);
        }
        return connect;
    }

    protected boolean setServos() {
        this.myServos.clear();
        this.myServoMap.clear();
        if (this.myConfig == null) {
            return true;
        }
        Map params = ((MaestroControllerConfig)this.myConfig).getServoConfigs();
        if (params == null) {
            return true;
        }
        for (ServoConfig param : params.values()) {
            MaestroServo servo = new MaestroServo((ServoConfig<MaestroServo.Id>)param, this);
            MaestroServo.Id id = (MaestroServo.Id)servo.getId();
            ServoController.ServoId servoId = new ServoController.ServoId(this.getId(), (Object)id);
            MaestroServo.Id pId = servo.getPhysicalId();
            if (this.myServoMap.containsKey(servoId) || this.myPhysicalMap.containsKey(pId)) {
                theLogger.log(Level.WARNING, "Unable to add Servo with duplicate Id - {0}, {1}.", new Object[]{id, pId});
                continue;
            }
            this.myServos.add(servo);
            this.myServoMap.put(servoId, servo);
            this.myPhysicalMap.put(servo.getPhysicalId(), servo);
        }
        this.moveAllServos(3000L);
        return true;
    }

    public synchronized boolean moveServo(ServoController.ServoId<MaestroServo.Id> id, long lenMillisec) {
        if (ConnectionStatus.CONNECTED != this.myConnectionStatus) {
            return false;
        }
        Boolean e = this.getEnabled();
        if (e == null || !e.booleanValue() || !this.containsId(id)) {
            return true;
        }
        MaestroServo servo = (MaestroServo)this.getServo(id);
        if (!servo.getEnabled().booleanValue()) {
            return true;
        }
        byte physId = servo.getPhysicalId().getServoNumber();
        Integer goal = servo.getAbsoluteGoalPosition();
        if (goal == null) {
            return true;
        }
        if (!this.myPort.write(new byte[]{-86, 12, 4, physId, (byte)((goal = Integer.valueOf(goal * 4)) & 0x7F), (byte)(goal >> 7 & 0x7F)}) || !this.myPort.flushWriter()) {
            theLogger.log(Level.SEVERE, "Cannot move servo {0}, unable to write to serial port {1}", new Object[]{id, ((MaestroControllerConfig)this.myConfig).getPortName()});
            return false;
        }
        return true;
    }

    public synchronized boolean moveServos(ServoController.ServoId<MaestroServo.Id>[] ids, int len, int offset, long lenMillisec) {
        if (ConnectionStatus.CONNECTED != this.myConnectionStatus) {
            return false;
        }
        Boolean e = this.getEnabled();
        if (e == null || !e.booleanValue()) {
            return true;
        }
        if (len == 0) {
            return true;
        }
        if (len == 1) {
            if (!this.containsId(ids[offset + 0])) {
                return true;
            }
            return this.moveServo(ids[offset + 0], lenMillisec);
        }
        Object[] pIds = new MaestroServo.Id[len];
        int pCnt = 0;
        for (int i = offset; i < offset + len; ++i) {
            MaestroServo joint = (MaestroServo)((Object)this.myServoMap.get(ids[i]));
            if (joint == null || !joint.getEnabled().booleanValue() || joint.getAbsoluteGoalPosition() == null) continue;
            pIds[pCnt] = joint.getPhysicalId();
            pCnt = (byte)(pCnt + 1);
        }
        Arrays.sort(pIds, 0, pCnt);
        boolean success = true;
        if (pCnt <= 0) {
            return success;
        }
        Object prev = pIds[0];
        byte cnt = 1;
        for (int i = 1; i < pCnt; i = (int)((byte)(i + 1))) {
            if (!((MaestroServo.Id)pIds[i - 1]).isConsecutive((MaestroServo.Id)pIds[i])) {
                success = success && this.moveConsecutiveServos((MaestroServo.Id)prev, cnt);
                prev = pIds[i];
                cnt = 0;
            }
            cnt = (byte)(cnt + 1);
        }
        return success && this.moveConsecutiveServos((MaestroServo.Id)prev, cnt);
    }

    protected synchronized boolean moveConsecutiveServos(MaestroServo.Id startId, byte count) {
        if (ConnectionStatus.CONNECTED != this.myConnectionStatus) {
            return false;
        }
        if (!this.getEnabled().booleanValue()) {
            return true;
        }
        int n = count * 2 + 5;
        byte[] bytes = new byte[n];
        bytes[0] = -86;
        bytes[1] = 12;
        bytes[2] = 31;
        bytes[3] = count;
        bytes[4] = startId.getServoNumber();
        int k = 5;
        for (byte i = 0; i < count; i = (byte)(i + 1)) {
            MaestroServo.Id next = startId.getOffsetId(i);
            if (next == null) continue;
            MaestroServo servo = this.myPhysicalMap.get(next);
            int goal = servo.getAbsoluteGoalPosition() * 4;
            bytes[k++] = (byte)(goal & 0x7F);
            bytes[k++] = (byte)(goal >> 7 & 0x7F);
        }
        return this.myPort.write(bytes, 0, k);
    }

    public boolean moveAllServos(long lenMillisec) {
        if (ConnectionStatus.CONNECTED != this.myConnectionStatus) {
            return false;
        }
        ServoController.ServoId[] ids = this.myServoMap.keySet().toArray(new ServoController.ServoId[0]);
        return this.moveServos(ids, ids.length, 0, lenMillisec);
    }

    protected MaestroServo connectServo(ServoConfig<MaestroServo.Id> config) {
        MaestroServo joint = new MaestroServo(config, this);
        return joint;
    }

    protected boolean disconnectServo(ServoController.ServoId<MaestroServo.Id> id) {
        return true;
    }

    protected void changeServoPhysicalId(MaestroServo.Id oldId, MaestroServo.Id newId) {
        MaestroServo joint = this.myPhysicalMap.remove(oldId);
        this.myPhysicalMap.put(newId, joint);
        this.firePropertyChange("Servos", null, this.myServoMap);
    }

    public void setEnabled(Boolean enabled) {
        Boolean old = this.myEnabledFlag;
        this.myEnabledFlag = enabled;
        for (MaestroServo servo : this.myServos) {
            servo.setEnabled(enabled);
        }
        this.firePropertyChange("enabled", old, enabled);
    }

    public Boolean getEnabled() {
        return this.myEnabledFlag;
    }

    public Class<MaestroServo.Id> getServoIdClass() {
        return MaestroServo.Id.class;
    }
}

