/*
 * Copyright 2011 Hanson Robokind LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.robokind.impl.motion.messaging;

import javax.jms.Destination;
import javax.jms.Session;
import org.robokind.api.motion.Robot;
import org.robokind.api.motion.messaging.RemoteRobotClient;
import org.robokind.impl.motion.messaging.command.PortableRobotRequestFactory;

/**
 *
 * @author Matthew Stevenson <www.robokind.org>
 */
public class JMSRemoteRobotClient extends RemoteRobotClient {
    
    public JMSRemoteRobotClient(
            Robot.Id robotId, String sourceId, String destId, 
            Session session,
            Destination requestDestination,
            Destination responseDestination,
            Destination motionFrameDestination) throws Exception{
        super(robotId, sourceId, destId, new PortableRobotRequestFactory());
        
        JMSRobotRequestSender reqSender = 
                new JMSRobotRequestSender(session, requestDestination);
        reqSender.start();
        setRequestSender(reqSender);
        
        JMSRobotResponseBlockingReceiver respRec =
                new JMSRobotResponseBlockingReceiver(
                        session, responseDestination);
        respRec.start();
        setResponseReceiver(respRec);
        
        JMSMotionFrameSender frameSender = 
                new JMSMotionFrameSender(session, motionFrameDestination);
        frameSender.setSourceId(sourceId);
        frameSender.setDestinationId(destId);
        frameSender.start();
        setMotionFrameSender(frameSender);
    }
}
