/*
 * Copyright 2011 Hanson Robokind LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.robokind.impl.motion.messaging;

import javax.jms.Destination;
import javax.jms.Session;
import org.robokind.api.common.utils.Listener;
import org.robokind.api.motion.Robot;
import org.robokind.api.motion.messaging.RemoteRobotHost;
import org.robokind.api.motion.protocol.MotionFrameEvent;
import org.robokind.impl.motion.messaging.command.PortableRobotResponseFactory;

/**
 *
 * @author Matthew Stevenson <www.robokind.org>
 */
public class JMSRemoteRobotHost extends RemoteRobotHost{
    private Session mySession;
    private Destination myRequestDestination;
    private Destination myResponseDestination;
    private Destination myMotionFrameDestination;
    
    public JMSRemoteRobotHost(Robot robot, 
            String sourceId, String destinationId,
            Session session,
            Destination requestDestination,
            Destination responseDestination,
            Destination motionFrameDestination,
            Listener<MotionFrameEvent> moveHandler) throws Exception{
        super(sourceId, destinationId);
        if(session == null || requestDestination == null ||
                responseDestination == null || motionFrameDestination == null){
            throw new NullPointerException();
        }
        mySession = session;
        myRequestDestination = requestDestination;
        myResponseDestination = responseDestination;
        myMotionFrameDestination = motionFrameDestination;
        setRobot(robot);
        setMoveHandle(moveHandler);
        setResponseFactory(new PortableRobotResponseFactory());
        JMSRobotResponseSender sender = 
                new JMSRobotResponseSender(mySession, myResponseDestination);
        sender.start();
        setResponseSender(sender);
        JMSRobotRequestAsyncReceiver reqReceiver = 
                new JMSRobotRequestAsyncReceiver(mySession, myRequestDestination);
        reqReceiver.start();
        setRequestReceiver(reqReceiver);
        JMSMotionFrameAsyncReceiver frameReceiver = 
                new JMSMotionFrameAsyncReceiver(
                        mySession, myMotionFrameDestination);
        frameReceiver.start();
        setMotionFrameReceiver(frameReceiver);
    }
}
