/*
 * Copyright 2011 Hanson Robokind LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.robokind.impl.motion.messaging;

import javax.jms.Destination;
import javax.jms.Session;
import org.robokind.api.common.utils.Adapter;
import org.robokind.api.common.utils.Listener;
import org.robokind.api.motion.messaging.messages.RobotRequest;
import org.robokind.avrogen.motion.RobotRequestRecord;
import org.robokind.impl.messaging.JMSAvroMessageSender;
import org.robokind.impl.motion.messaging.command.PortableRobotRequest;

/**
 *
 * @author Matthew Stevenson <www.robokind.org>
 */
public class JMSRobotRequestSender extends JMSAvroMessageSender<
        RobotRequest, RobotRequestRecord, Listener<RobotRequest>> {
    public JMSRobotRequestSender(Session session, Destination destination){
        super(session, destination);
        setAdapter(new RobotRequestAdapter());
    }
    /**
     * Converts a RobotRequest to a RobotRequestRecord.
     */
    public static class RobotRequestAdapter 
            implements Adapter<RobotRequest, RobotRequestRecord>{
        @Override
        public RobotRequestRecord adapt(RobotRequest a) {
            return new PortableRobotRequest(a).getRecord();
        }
    }
}
