/*
 * Copyright 2011 Hanson Robokind LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.robokind.impl.motion.messaging;

import org.robokind.api.common.utils.Listener;
import org.robokind.api.motion.Robot.RobotPositionMap;
import org.robokind.api.motion.protocol.MotionFrame;
import org.robokind.api.motion.protocol.MotionFrameEvent;
import org.robokind.api.motion.utils.PositionTargetFrameSource;

/**
 *
 * Listens for MotionFrameEvents and passes them a PositionTargetFrameSource.
 * @author Matthew Stevenson <www.robokind.org>
 */
public class TargetFrameListener implements Listener<MotionFrameEvent>{
    private PositionTargetFrameSource myPositionTargetFrameSource;
    /**
     * Sets the PositionTargetFrameSource to pass goal positions to.
     * @param posTargetFrameSource PositionTargetFrameSource to use
     */
    public void setRobotFrameSource(
            PositionTargetFrameSource posTargetFrameSource){
        myPositionTargetFrameSource = posTargetFrameSource;
    }
    
    @Override
    public void handleEvent(MotionFrameEvent event) {
        if(myPositionTargetFrameSource == null){
            return;
        }else if(event == null){
            return;
        }
        MotionFrame<RobotPositionMap> frame = event.getMotionFrame();
        if(frame == null){
            return;
        }
        myPositionTargetFrameSource.putPositions(frame.getGoalPositions());
    }   
}
