/*
 * Copyright 2011 Hanson Robokind LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.robokind.impl.motion.messaging.command;

import org.robokind.api.motion.Robot;
import org.robokind.api.motion.Robot.JointId;
import org.robokind.api.motion.messaging.messages.RobotRequestFactory;

/**
 *
 * @author Matthew Stevenson <www.robokind.org>
 */
public class PortableRobotRequestFactory implements RobotRequestFactory<PortableRobotRequest> {

    @Override
    public PortableRobotRequest buildRobotRequest(Robot.Id robotId, 
            String sourceId, String destId, 
            String requestType, long timestampMillisecUTC) {
        return new PortableRobotRequest(robotId, sourceId, destId, 
                requestType, timestampMillisecUTC, null);
    }

    @Override
    public PortableRobotRequest buildJointRequest(
            JointId jointId, String sourceId, String destId, 
            String requestType, long timestampMillisecUTC) {
        Robot.Id robotId = jointId.getRobotId();
        Integer jointIdInt = jointId.getJointId().getLogicalJointNumber();
        return new PortableRobotRequest(robotId, sourceId, destId, 
                requestType, timestampMillisecUTC, jointIdInt);
    }
    
}
