/*
 * Copyright 2011 Hanson Robokind LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.robokind.impl.motion.messaging.command;

import org.robokind.api.common.utils.TimeUtils;
import org.robokind.api.motion.Robot;
import org.robokind.api.motion.Robot.Id;
import org.robokind.api.motion.Robot.RobotPositionMap;
import org.robokind.api.motion.messaging.messages.RobotDefinitionResponse;
import org.robokind.api.motion.messaging.messages.RobotResponse.RobotPositionResponse;
import org.robokind.api.motion.messaging.messages.RobotResponse.RobotResponseHeader;
import org.robokind.api.motion.messaging.messages.RobotResponse.RobotStatusResponse;
import org.robokind.api.motion.messaging.messages.RobotResponseFactory;

/**
 *
 * @author Matthew Stevenson <www.robokind.org>
 */
public class PortableRobotResponseFactory implements RobotResponseFactory{

    @Override
    public RobotResponseHeader createHeader(Id robotId, 
            String sourceId, String destinationId, 
            String commandType, long requesTimestamp) {
        return new PortableRobotResponseHeader(
                robotId, sourceId, destinationId, 
                commandType, requesTimestamp, TimeUtils.now());
    }

    @Override
    public RobotDefinitionResponse createDefinitionResponse(
            RobotResponseHeader header, Robot robot) {
        return new PortableRobotDefinitionResponse(header, robot);
    }

    @Override
    public RobotStatusResponse createStatusResponse(
            RobotResponseHeader header, boolean status) {
        return new PortableRobotStatusResponse(header, status);
    }

    @Override
    public RobotPositionResponse createPositionResponse(
            RobotResponseHeader header, RobotPositionMap positions) {
        return new PortableRobotPositionResponse(header, positions);
    }
    
}
