/*
 * Copyright 2011 Hanson Robokind LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.robokind.impl.motion.messaging.command;

import org.apache.avro.util.Utf8;
import org.robokind.api.motion.Robot;
import org.robokind.api.motion.messaging.messages.RobotResponse.RobotResponseHeader;
import org.robokind.avrogen.motion.RobotResponseHeaderRecord;

/**
 *
 * @author Matthew Stevenson <www.robokind.org>
 */
public class PortableRobotResponseHeader implements RobotResponseHeader{
    private RobotResponseHeaderRecord myRecord;
    private Robot.Id myCachedId;
    
    public PortableRobotResponseHeader(RobotResponseHeaderRecord record){
        if(record == null){
            throw new NullPointerException();
        }
        myRecord = record;
        myCachedId = new Robot.Id(myRecord.robotId.toString());
    }
    
    public PortableRobotResponseHeader(RobotResponseHeader header){
        if(header == null){
            throw new NullPointerException();
        }else if(header instanceof PortableRobotResponseHeader){
            myRecord = ((PortableRobotResponseHeader)header).getRecord();
            myCachedId = new Robot.Id(myRecord.robotId.toString());
            return;
        }
        myCachedId = header.getRobotId();
        myRecord = new RobotResponseHeaderRecord();
        myRecord.robotId = new Utf8(myCachedId.getRobtIdString());
        myRecord.requestSourceId = new Utf8(header.getSourceId());
        myRecord.requestDestinationId = new Utf8(header.getDestinationId());
        myRecord.requestType = new Utf8(header.getRequestType());
        myRecord.requestTimestampMillisecUTC = 
                header.getRequestTimestampMillisecUTC();
        myRecord.responseTimestampMillisecUTC = 
                header.getResponseTimestampMillisecUTC();
    }
    
    public PortableRobotResponseHeader(
            Robot.Id robotId, String sourceId, String destId, 
            String commandType, long requestTimestampMillisecUTC, 
            long responseTimestampMillisecUTC){
        myCachedId = robotId;
        myRecord = new RobotResponseHeaderRecord();
        myRecord.robotId = new Utf8(myCachedId.getRobtIdString());
        myRecord.requestSourceId = new Utf8(sourceId);
        myRecord.requestDestinationId = new Utf8(destId);
        myRecord.requestType = new Utf8(commandType);
        myRecord.requestTimestampMillisecUTC = requestTimestampMillisecUTC;
        myRecord.responseTimestampMillisecUTC = responseTimestampMillisecUTC;
    }
    
    @Override
    public Robot.Id getRobotId() {
        return myCachedId;
    }

    @Override
    public String getSourceId() {
        return myRecord.requestSourceId.toString();
    }

    @Override
    public String getDestinationId() {
        return myRecord.requestDestinationId.toString();
    }

    @Override
    public String getRequestType() {
        return myRecord.requestType.toString();
    }

    @Override
    public long getRequestTimestampMillisecUTC() {
       return myRecord.requestTimestampMillisecUTC;
    }

    @Override
    public long getResponseTimestampMillisecUTC() {
       return myRecord.responseTimestampMillisecUTC;
    }
    
    public RobotResponseHeaderRecord getRecord(){
        return myRecord;
    }
    
}
