/*
 * Copyright 2011 Hanson Robokind LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.robokind.impl.motion.messaging.command;

import org.robokind.api.motion.messaging.messages.RobotResponse.RobotStatusResponse;
import org.robokind.avrogen.motion.RobotStatusResponseRecord;

/**
 *
 * @author Matthew Stevenson <www.robokind.org>
 */
public class PortableRobotStatusResponse implements RobotStatusResponse{
    private RobotStatusResponseRecord myRecord;
    private PortableRobotResponseHeader myCachedHeader;
    
    public PortableRobotStatusResponse(RobotStatusResponseRecord record){
        if(record == null){
            throw new NullPointerException();
        }
        myRecord = record;
        myCachedHeader = 
                new PortableRobotResponseHeader(myRecord.responseHeader);
    }
    
    public PortableRobotStatusResponse(RobotStatusResponse response){
        if(response == null){
            throw new NullPointerException();
        }else if(response instanceof PortableRobotStatusResponse){
            PortableRobotStatusResponse pr = 
                    ((PortableRobotStatusResponse)response);
            myRecord = pr.getRecord();
            myCachedHeader = pr.myCachedHeader;
            return;
        }
        setHeader(response.getResponseHeader());
        myRecord = new RobotStatusResponseRecord();
        myRecord.responseHeader = myCachedHeader.getRecord();
    }
    
    public PortableRobotStatusResponse(
            RobotResponseHeader header, boolean status){
        if(header == null){
            throw new NullPointerException();
        }
        setHeader(header);
        myRecord = new RobotStatusResponseRecord();
        myRecord.statusResponse = status;
        myRecord.responseHeader = myCachedHeader.getRecord();
    }
    
    private void setHeader(RobotResponseHeader header){
        if(header instanceof PortableRobotResponseHeader){
            myCachedHeader = (PortableRobotResponseHeader)header;
        }else{
            myCachedHeader = new PortableRobotResponseHeader(header);
        }
    }

    @Override
    public RobotResponseHeader getResponseHeader() {
        return myCachedHeader;
    }

    @Override
    public boolean getStatusResponse() {
        return myRecord.statusResponse;
    }
    
    public RobotStatusResponseRecord getRecord(){
        return myRecord;
    }
}
