/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.motion.messaging;

import javax.jms.Destination;
import javax.jms.Session;
import org.robokind.api.common.utils.Listener;
import org.robokind.api.messaging.MessageAsyncReceiver;
import org.robokind.api.messaging.MessageSender;
import org.robokind.api.motion.Robot;
import org.robokind.api.motion.messaging.RemoteRobotHost;
import org.robokind.api.motion.protocol.MotionFrameEvent;
import org.robokind.impl.motion.messaging.JMSMotionFrameAsyncReceiver;
import org.robokind.impl.motion.messaging.JMSRobotRequestAsyncReceiver;
import org.robokind.impl.motion.messaging.JMSRobotResponseSender;
import org.robokind.impl.motion.messaging.command.PortableRobotResponseFactory;

public class JMSRemoteRobotHost
extends RemoteRobotHost {
    private Session mySession;
    private Destination myRequestDestination;
    private Destination myResponseDestination;
    private Destination myMotionFrameDestination;

    public JMSRemoteRobotHost(Robot robot, String sourceId, String destinationId, Session session, Destination requestDestination, Destination responseDestination, Destination motionFrameDestination, Listener<MotionFrameEvent> moveHandler) throws Exception {
        super(sourceId, destinationId);
        if (session == null || requestDestination == null || responseDestination == null || motionFrameDestination == null) {
            throw new NullPointerException();
        }
        this.mySession = session;
        this.myRequestDestination = requestDestination;
        this.myResponseDestination = responseDestination;
        this.myMotionFrameDestination = motionFrameDestination;
        this.setRobot(robot);
        this.setMoveHandle(moveHandler);
        this.setResponseFactory(new PortableRobotResponseFactory());
        JMSRobotResponseSender sender = new JMSRobotResponseSender(this.mySession, this.myResponseDestination);
        sender.start();
        this.setResponseSender((MessageSender)sender);
        JMSRobotRequestAsyncReceiver reqReceiver = new JMSRobotRequestAsyncReceiver(this.mySession, this.myRequestDestination);
        reqReceiver.start();
        this.setRequestReceiver((MessageAsyncReceiver)reqReceiver);
        JMSMotionFrameAsyncReceiver frameReceiver = new JMSMotionFrameAsyncReceiver(this.mySession, this.myMotionFrameDestination);
        frameReceiver.start();
        this.setMotionFrameReceiver((MessageAsyncReceiver)frameReceiver);
    }
}

