/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.motion.messaging;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Destination;
import javax.jms.Session;
import org.apache.avro.specific.SpecificRecordBase;
import org.robokind.api.common.utils.Adapter;
import org.robokind.api.common.utils.Listener;
import org.robokind.api.motion.messaging.messages.RobotDefinitionResponse;
import org.robokind.api.motion.messaging.messages.RobotResponse;
import org.robokind.impl.messaging.JMSAvroMessageSender;
import org.robokind.impl.motion.messaging.command.PortableRobotDefinitionResponse;
import org.robokind.impl.motion.messaging.command.PortableRobotPositionResponse;
import org.robokind.impl.motion.messaging.command.PortableRobotStatusResponse;

public class JMSRobotResponseSender
extends JMSAvroMessageSender<RobotResponse, SpecificRecordBase, Listener<RobotResponse>> {
    static final Logger theLogger = Logger.getLogger(JMSRobotResponseSender.class.getName());

    public JMSRobotResponseSender(Session session, Destination destination) {
        super(session, destination);
        this.setAdapter(new RobotResponseAdapter());
    }

    public void sendMessage(RobotResponse message) {
        theLogger.log(Level.INFO, "Sending Robot Response: {0}, to: {1}", new Object[]{message.getResponseHeader().getRequestType(), message.getResponseHeader().getRobotId().getRobtIdString()});
        String contentType = this.getContentType(message);
        if (contentType == null) {
            theLogger.warning("Cannot find contentType, unable to send message.");
            return;
        }
        this.sendMessage(message, contentType);
    }

    public String getContentType(RobotResponse a) {
        if (a == null) {
            throw new NullPointerException();
        }
        if (a instanceof RobotDefinitionResponse) {
            return "application/avro-robot-def-resp";
        }
        if (a instanceof RobotResponse.RobotStatusResponse) {
            return "application/avro-robot-stat-resp";
        }
        if (a instanceof RobotResponse.RobotPositionResponse) {
            return "application/avro-robot-pos-resp";
        }
        return null;
    }

    public static class RobotResponseAdapter
    implements Adapter<RobotResponse, SpecificRecordBase> {
        public SpecificRecordBase adapt(RobotResponse a) {
            if (a == null) {
                throw new NullPointerException();
            }
            if (a instanceof RobotDefinitionResponse) {
                if (a instanceof PortableRobotDefinitionResponse) {
                    return ((PortableRobotDefinitionResponse)a).getRecord();
                }
                return new PortableRobotDefinitionResponse((RobotDefinitionResponse)a).getRecord();
            }
            if (a instanceof RobotResponse.RobotStatusResponse) {
                if (a instanceof PortableRobotStatusResponse) {
                    return ((PortableRobotStatusResponse)a).getRecord();
                }
                return new PortableRobotStatusResponse((RobotResponse.RobotStatusResponse)a).getRecord();
            }
            if (a instanceof RobotResponse.RobotPositionResponse) {
                if (a instanceof PortableRobotPositionResponse) {
                    return ((PortableRobotPositionResponse)a).getRecord();
                }
                return new PortableRobotPositionResponse((RobotResponse.RobotPositionResponse)a).getRecord();
            }
            return null;
        }
    }
}

