/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.motion.messaging.command;

import org.apache.avro.util.Utf8;
import org.robokind.api.motion.Robot;
import org.robokind.api.motion.messaging.messages.RobotRequest;
import org.robokind.avrogen.motion.RobotRequestRecord;

public class PortableRobotRequest
implements RobotRequest {
    private RobotRequestRecord myRecord;
    private Robot.Id myCachedId;

    public PortableRobotRequest(RobotRequestRecord record) {
        if (record == null) {
            throw new NullPointerException();
        }
        this.myRecord = record;
        this.myCachedId = new Robot.Id(this.myRecord.robotId.toString());
    }

    public PortableRobotRequest(RobotRequest request) {
        if (request == null) {
            throw new NullPointerException();
        }
        if (request instanceof PortableRobotRequest) {
            this.myRecord = ((PortableRobotRequest)request).getRecord();
            this.myCachedId = new Robot.Id(this.myRecord.robotId.toString());
            return;
        }
        this.myCachedId = request.getRobotId();
        this.myRecord = new RobotRequestRecord();
        this.myRecord.robotId = new Utf8(this.myCachedId.getRobtIdString());
        this.myRecord.requestSourceId = new Utf8(request.getSourceId());
        this.myRecord.requestDestinationId = new Utf8(request.getDestinationId());
        this.myRecord.requestType = new Utf8(request.getRequestType());
        this.myRecord.timestampMillisecUTC = request.getTimestampMillisecUTC();
    }

    public PortableRobotRequest(Robot.Id robotId, String sourceId, String destId, String requestType, long timestampMillisecUTC, Integer requestIndex) {
        this.myCachedId = robotId;
        this.myRecord = new RobotRequestRecord();
        this.myRecord.robotId = new Utf8(this.myCachedId.getRobtIdString());
        this.myRecord.requestSourceId = new Utf8(sourceId);
        this.myRecord.requestDestinationId = new Utf8(destId);
        this.myRecord.requestType = new Utf8(requestType);
        this.myRecord.timestampMillisecUTC = timestampMillisecUTC;
        this.myRecord.intParam = requestIndex;
    }

    public Robot.Id getRobotId() {
        return this.myCachedId;
    }

    public String getSourceId() {
        return this.myRecord.requestSourceId.toString();
    }

    public String getDestinationId() {
        return this.myRecord.requestDestinationId.toString();
    }

    public String getRequestType() {
        return this.myRecord.requestType.toString();
    }

    public long getTimestampMillisecUTC() {
        return this.myRecord.timestampMillisecUTC;
    }

    public Integer getRequestIndex() {
        return this.myRecord.intParam;
    }

    public RobotRequestRecord getRecord() {
        return this.myRecord;
    }
}

