/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.motion.osgi;

import java.io.File;
import java.util.Dictionary;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.robokind.api.common.services.ServiceConfigurationLoader;
import org.robokind.api.common.services.ServiceConfigurationWriter;
import org.robokind.api.common.services.ServiceFactory;
import org.robokind.api.common.services.ServiceUtils;
import org.robokind.api.motion.jointgroup.JointGroup;
import org.robokind.api.motion.jointgroup.RobotJointGroup;
import org.robokind.api.motion.jointgroup.RobotJointGroupConfig;
import org.robokind.api.motion.jointgroup.RobotJointGroupFactory;
import org.robokind.api.motion.servos.config.ServoRobotConfig;
import org.robokind.impl.motion.config.RobotConfigXMLFileLoader;
import org.robokind.impl.motion.config.RobotConfigXMLReader;
import org.robokind.impl.motion.jointgroup.RobotJointGroupConfigXMLReader;
import org.robokind.impl.motion.jointgroup.RobotJointGroupXMLFileLoader;
import org.robokind.impl.motion.sync.SynchronizedRobotConfigLoader;
import org.robokind.impl.motion.sync.SynchronizedRobotConfigWriter;

public class Activator
implements BundleActivator {
    private static final Logger theLogger = Logger.getLogger(Activator.class.getName());

    public void start(BundleContext context) throws Exception {
        theLogger.log(Level.INFO, "MotionAPI Activation Begin.");
        this.registerRobotXMLReader(context);
        this.registerRobotXMLFileLoader(context);
        this.registerJointGroupXMLReader(context);
        this.registerJointGroupXMLFileLoader(context);
        this.registerRobotJointGroupFactory(context);
        ServiceRegistration loadReg = ServiceUtils.registerConfigurationLoader((BundleContext)context, (ServiceConfigurationLoader)new SynchronizedRobotConfigLoader(), null);
        ServiceRegistration writeReg = ServiceUtils.registerConfigurationWriter((BundleContext)context, (ServiceConfigurationWriter)new SynchronizedRobotConfigWriter(), null);
        theLogger.log(Level.INFO, "MotionAPI Activation Complete.");
    }

    private void registerRobotXMLReader(BundleContext context) {
        RobotConfigXMLReader reader = new RobotConfigXMLReader(context);
        Properties props = new Properties();
        props.put("ConfigurationFormatVersion", RobotConfigXMLReader.VERSION.toString());
        props.put("ServiceConfigurationClass", ServoRobotConfig.class.getName());
        props.put("ServiceConfigParameterClass", HierarchicalConfiguration.class.getName());
        context.registerService(ServiceConfigurationLoader.class.getName(), (Object)reader, (Dictionary)props);
        theLogger.log(Level.INFO, "RobotConfig XML Reader Service Registered Successfully.");
    }

    private void registerRobotXMLFileLoader(BundleContext context) {
        RobotConfigXMLFileLoader reader = new RobotConfigXMLFileLoader(context);
        Properties props = new Properties();
        props.put("ConfigurationFormatVersion", RobotConfigXMLReader.VERSION.toString());
        props.put("ServiceConfigurationClass", ServoRobotConfig.class.getName());
        props.put("ServiceConfigParameterClass", File.class.getName());
        context.registerService(ServiceConfigurationLoader.class.getName(), (Object)reader, (Dictionary)props);
        theLogger.log(Level.INFO, "RobotConfig XML File Reader Service Registered Successfully.");
    }

    private void registerJointGroupXMLReader(BundleContext context) {
        RobotJointGroupConfigXMLReader reader = new RobotJointGroupConfigXMLReader();
        Properties props = new Properties();
        props.put("ConfigurationFormatVersion", RobotJointGroupConfigXMLReader.VERSION.toString());
        props.put("ServiceConfigurationClass", RobotJointGroupConfig.class.getName());
        props.put("ServiceConfigParameterClass", HierarchicalConfiguration.class.getName());
        context.registerService(ServiceConfigurationLoader.class.getName(), (Object)reader, (Dictionary)props);
        theLogger.log(Level.INFO, "JointGroupConfig XML Reader Service Registered Successfully.");
    }

    private void registerJointGroupXMLFileLoader(BundleContext context) {
        RobotJointGroupXMLFileLoader reader = new RobotJointGroupXMLFileLoader();
        Properties props = new Properties();
        props.put("ConfigurationFormatVersion", RobotJointGroupConfigXMLReader.VERSION.toString());
        props.put("ServiceConfigurationClass", RobotJointGroupConfig.class.getName());
        props.put("ServiceConfigParameterClass", File.class.getName());
        context.registerService(ServiceConfigurationLoader.class.getName(), (Object)reader, (Dictionary)props);
        theLogger.log(Level.INFO, "JointGroupConfig XML File Reader Service Registered Successfully.");
    }

    private void registerRobotJointGroupFactory(BundleContext context) {
        RobotJointGroupFactory fact = new RobotJointGroupFactory();
        Properties props = new Properties();
        props.put("ServiceVersion", RobotJointGroup.VERSION.toString());
        props.put("ServiceClass", JointGroup.class.getName());
        context.registerService(ServiceFactory.class.getName(), (Object)fact, (Dictionary)props);
        theLogger.log(Level.INFO, "RobotJointGroup Factory Service Registered Successfully.");
    }

    public void stop(BundleContext context) throws Exception {
    }
}

