/*
 * Copyright 2011 Hanson Robokind LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.robokind.impl.motion.messaging;

import javax.jms.Destination;
import javax.jms.Session;
import org.robokind.api.common.utils.Adapter;
import org.robokind.api.motion.protocol.MotionFrameEvent;
import org.robokind.avrogen.motion.MotionFrameEventRecord;
import org.robokind.impl.messaging.JMSAvroMessageAsyncReceiver;

/**
 * JMSAvroMessageAsyncReceiver for receiving MotionFrameEvents.
 * @author Matthew Stevenson <www.robokind.org>
 */
public class JMSMotionFrameAsyncReceiver extends 
        JMSAvroMessageAsyncReceiver<MotionFrameEvent,MotionFrameEventRecord> {
    /**
     * Creates a new JMSMotionFrameAsyncReceiver
     * @param session JMS Session to use
     * @param destination JMS Destination to use
     */
    public JMSMotionFrameAsyncReceiver(Session session, Destination destination){
        super(session, destination,
                MotionFrameEventRecord.class, MotionFrameEventRecord.SCHEMA$);
        setAdapter(new MotionFrameEventRecordAdapter());
    }
    /**
     * Converts a MotionFrameEventRecord to a MotionFrameEvent
     */
    public static class MotionFrameEventRecordAdapter
            implements Adapter<MotionFrameEventRecord, MotionFrameEvent>{
        @Override
        public MotionFrameEvent adapt(MotionFrameEventRecord a) {
            return new PortableMotionFrameEvent(a);
        }
    }
}
