/*
 * Copyright 2011 Hanson Robokind LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.robokind.impl.motion.messaging;

import javax.jms.Destination;
import javax.jms.Session;
import org.robokind.api.common.utils.Adapter;
import org.robokind.api.common.utils.Listener;
import org.robokind.api.motion.messaging.messages.RobotRequest;
import org.robokind.avrogen.motion.RobotRequestRecord;
import org.robokind.impl.messaging.JMSAvroMessageAsyncReceiver;
import org.robokind.impl.motion.messaging.command.PortableRobotRequest;

/**
 *
 * @author Matthew Stevenson <www.robokind.org>
 */
public class JMSRobotRequestAsyncReceiver extends 
        JMSAvroMessageAsyncReceiver<RobotRequest, RobotRequestRecord> {
    
    public JMSRobotRequestAsyncReceiver(Session session, Destination destination){
        super(session, destination, 
                RobotRequestRecord.class, 
                RobotRequestRecord.SCHEMA$);
        setAdapter(new RobotRequestRecordAdapter());
    }
    /**
     * Converts a RobotRequest to a RobotRequestRecord.
     */
    public static class RobotRequestRecordAdapter 
            implements Adapter<RobotRequestRecord, RobotRequest>{
        @Override
        public RobotRequest adapt(RobotRequestRecord a) {
            return new PortableRobotRequest(a);
        }
    }
}
