/*
 * Copyright 2011 Hanson Robokind LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.robokind.impl.motion.sync;

import java.io.File;
import org.robokind.api.common.config.VersionProperty;
import org.robokind.api.common.services.ServiceConfigurationWriter;
import org.robokind.api.motion.sync.SynchronizedRobotConfig;
import org.robokind.avrogen.motion.SynchronizedRobotConfigRecord;
import org.robokind.bind.apache_avro.AvroUtils;

/**
 *
 * @author Matthew Stevenson <www.robokind.org>
 */
public class SynchronizedRobotConfigWriter implements 
        ServiceConfigurationWriter<SynchronizedRobotConfig, File> {

    @Override
    public VersionProperty getConfigurationFormat() {
        return SynchronizedRobotConfigLoader.VERSION;
    }

    @Override
    public boolean writeConfiguration(SynchronizedRobotConfig config, File param) throws Exception {
        if(config == null || param == null){
            throw new NullPointerException();
        }
        SynchronizedRobotConfigRecord record;
        if(config instanceof PortableSynchronizedRobotConfig){
            record = ((PortableSynchronizedRobotConfig)config).getRecord();
        }else{
            record = new PortableSynchronizedRobotConfig(config).getRecord();
        }
        return AvroUtils.writeToFile(
                record,
                SynchronizedRobotConfigRecord.SCHEMA$, 
                param, true);
    }

    @Override
    public Class<SynchronizedRobotConfig> getConfigurationClass() {
        return SynchronizedRobotConfig.class;
    }

    @Override
    public Class<File> getParameterClass() {
        return File.class;
    }
    
}
