/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.motion.messaging;

import java.util.logging.Logger;
import javax.jms.Destination;
import javax.jms.Session;
import org.robokind.api.common.utils.Adapter;
import org.robokind.api.common.utils.TimeUtils;
import org.robokind.api.motion.Robot;
import org.robokind.api.motion.protocol.MotionFrame;
import org.robokind.api.motion.protocol.MotionFrameEvent;
import org.robokind.avrogen.motion.MotionFrameEventRecord;
import org.robokind.impl.messaging.JMSAvroMessageSender;
import org.robokind.impl.motion.messaging.PortableMotionFrameEvent;

public class JMSMotionFrameSender
extends JMSAvroMessageSender<MotionFrameEvent, MotionFrameEventRecord> {
    static final Logger theLogger = Logger.getLogger(JMSMotionFrameSender.class.getName());
    private String mySourceId;
    private String myDestinationId;

    public JMSMotionFrameSender(Session session, Destination destination) {
        super(session, destination);
        this.setAdapter(new MotionFrameEventAdapter());
    }

    public void setSourceId(String sourceId) {
        this.mySourceId = sourceId;
    }

    public void setDestinationId(String destId) {
        this.myDestinationId = destId;
    }

    public void sendMotionFrame(MotionFrame frame) {
        if (frame == null || this.mySourceId == null || this.myDestinationId == null) {
            throw new NullPointerException();
        }
        PortableMotionFrameEvent frameEvent = new PortableMotionFrameEvent(this.mySourceId, this.myDestinationId, TimeUtils.now(), (MotionFrame<Robot.RobotPositionMap>)frame);
        super.sendMessage((Object)frameEvent);
    }

    public static class MotionFrameEventAdapter
    implements Adapter<MotionFrameEvent, MotionFrameEventRecord> {
        public MotionFrameEventRecord adapt(MotionFrameEvent a) {
            return new PortableMotionFrameEvent(a).getMotionFrameEventRecord();
        }
    }
}

