/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.motion.messaging;

import javax.jms.Destination;
import javax.jms.Session;
import org.robokind.api.common.utils.Adapter;
import org.robokind.api.common.utils.TimeUtils;
import org.robokind.api.messaging.MessageBlockingReceiver;
import org.robokind.api.messaging.MessageSender;
import org.robokind.api.motion.Robot;
import org.robokind.api.motion.messaging.RemoteRobotClient;
import org.robokind.api.motion.messaging.messages.RobotRequestFactory;
import org.robokind.api.motion.protocol.MotionFrame;
import org.robokind.api.motion.protocol.MotionFrameEvent;
import org.robokind.impl.motion.messaging.JMSMotionFrameSender;
import org.robokind.impl.motion.messaging.JMSRobotRequestSender;
import org.robokind.impl.motion.messaging.JMSRobotResponseBlockingReceiver;
import org.robokind.impl.motion.messaging.PortableMotionFrameEvent;
import org.robokind.impl.motion.messaging.command.PortableRobotRequestFactory;

public class JMSRemoteRobotClient
extends RemoteRobotClient {
    public JMSRemoteRobotClient(Robot.Id robotId, String sourceId, String destId, Session session, Destination requestDestination, Destination responseDestination, Destination motionFrameDestination) throws Exception {
        super(robotId, sourceId, destId, (RobotRequestFactory)new PortableRobotRequestFactory(), (Adapter)new MotionFrameAdapter(sourceId, destId));
        JMSRobotRequestSender reqSender = new JMSRobotRequestSender(session, requestDestination);
        reqSender.start();
        this.setRequestSender((MessageSender)reqSender);
        JMSRobotResponseBlockingReceiver respRec = new JMSRobotResponseBlockingReceiver(session, responseDestination);
        respRec.start();
        this.setResponseReceiver((MessageBlockingReceiver)respRec);
        JMSMotionFrameSender frameSender = new JMSMotionFrameSender(session, motionFrameDestination);
        frameSender.setSourceId(sourceId);
        frameSender.setDestinationId(destId);
        frameSender.start();
        this.setMotionFrameSender((MessageSender)frameSender);
    }

    static class MotionFrameAdapter
    implements Adapter<MotionFrame, MotionFrameEvent> {
        private String mySourceId;
        private String myDestinationId;

        public MotionFrameAdapter(String sourceId, String destinationId) {
            this.mySourceId = sourceId;
            this.myDestinationId = destinationId;
        }

        public MotionFrameEvent adapt(MotionFrame a) {
            return new PortableMotionFrameEvent(this.mySourceId, this.myDestinationId, TimeUtils.now(), (MotionFrame<Robot.RobotPositionMap>)a);
        }
    }
}

