/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.motion.messaging;

import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import org.apache.avro.Schema;
import org.apache.qpid.client.message.JMSBytesMessage;
import org.robokind.api.common.utils.Adapter;
import org.robokind.api.messaging.DefaultMessageBlockingReceiver;
import org.robokind.api.messaging.RecordBlockingReceiver;
import org.robokind.api.motion.messaging.messages.RobotResponse;
import org.robokind.avrogen.motion.RobotDefinitionResponseRecord;
import org.robokind.avrogen.motion.RobotPositionResponseRecord;
import org.robokind.avrogen.motion.RobotStatusResponseRecord;
import org.robokind.bind.apache_qpid.QpidUtils;
import org.robokind.impl.messaging.JMSBytesRecordBlockingReceiver;
import org.robokind.impl.motion.messaging.command.PortableRobotDefinitionResponse;
import org.robokind.impl.motion.messaging.command.PortableRobotPositionResponse;
import org.robokind.impl.motion.messaging.command.PortableRobotStatusResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMSRobotResponseBlockingReceiver
extends DefaultMessageBlockingReceiver<RobotResponse, BytesMessage> {
    private static final Logger theLogger = LoggerFactory.getLogger(JMSRobotResponseBlockingReceiver.class);
    public static final String MIME_ROBOT_DEFINITION_RESPONSE = "application/avro-robot-def-resp";
    public static final String MIME_ROBOT_STATUS_RESPONSE = "application/avro-robot-stat-resp";
    public static final String MIME_ROBOT_POSITION_RESPONSE = "application/avro-robot-pos-resp";
    private Session mySession;
    private Destination myDestination;
    private JMSBytesRecordBlockingReceiver myReceiver;

    public JMSRobotResponseBlockingReceiver(Session session, Destination destination) throws JMSException {
        this.mySession = session;
        this.myDestination = destination;
        MessageConsumer consumer = this.mySession.createConsumer(this.myDestination);
        this.myReceiver = new JMSBytesRecordBlockingReceiver(consumer);
        this.setRecordReceiver((RecordBlockingReceiver)this.myReceiver);
        this.setAdapter(new RobotResponseRecordAdapter());
    }

    class RobotResponseRecordAdapter
    implements Adapter<BytesMessage, RobotResponse> {
        RobotResponseRecordAdapter() {
        }

        public RobotResponse adapt(BytesMessage a) {
            String mime = ((JMSBytesMessage)a).getEncoding();
            if (mime == null || mime.isEmpty()) {
                return null;
            }
            if (JMSRobotResponseBlockingReceiver.MIME_ROBOT_DEFINITION_RESPONSE.equals(mime)) {
                return this.getDefinitionResponse(a);
            }
            if (JMSRobotResponseBlockingReceiver.MIME_ROBOT_STATUS_RESPONSE.equals(mime)) {
                return this.getStatusResponse(a);
            }
            if (JMSRobotResponseBlockingReceiver.MIME_ROBOT_POSITION_RESPONSE.equals(mime)) {
                return this.getPositionResponse(a);
            }
            return null;
        }

        private RobotResponse getDefinitionResponse(BytesMessage bmsg) {
            try {
                RobotDefinitionResponseRecord record = (RobotDefinitionResponseRecord)QpidUtils.unpackAvroMessage(RobotDefinitionResponseRecord.class, null, (Schema)RobotDefinitionResponseRecord.SCHEMA$, (BytesMessage)bmsg);
                return new PortableRobotDefinitionResponse(record);
            }
            catch (Exception ex) {
                theLogger.error("Error deserializing Avro Record.", (Throwable)ex);
                return null;
            }
        }

        private RobotResponse getStatusResponse(BytesMessage bmsg) {
            try {
                RobotStatusResponseRecord record = (RobotStatusResponseRecord)QpidUtils.unpackAvroMessage(RobotStatusResponseRecord.class, null, (Schema)RobotStatusResponseRecord.SCHEMA$, (BytesMessage)bmsg);
                return new PortableRobotStatusResponse(record);
            }
            catch (Exception ex) {
                theLogger.error("Error deserializing Avro Record.", (Throwable)ex);
                return null;
            }
        }

        private RobotResponse getPositionResponse(BytesMessage bmsg) {
            try {
                RobotPositionResponseRecord record = (RobotPositionResponseRecord)QpidUtils.unpackAvroMessage(RobotPositionResponseRecord.class, null, (Schema)RobotPositionResponseRecord.SCHEMA$, (BytesMessage)bmsg);
                return new PortableRobotPositionResponse(record);
            }
            catch (Exception ex) {
                theLogger.error("Error deserializing Avro Record.", (Throwable)ex);
                return null;
            }
        }
    }
}

