/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.motion.messaging.command;

import java.util.ArrayList;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.robokind.api.motion.Joint;
import org.robokind.api.motion.Robot;
import org.robokind.api.motion.messaging.messages.RobotDefinitionResponse;
import org.robokind.api.motion.messaging.messages.RobotResponse;
import org.robokind.avrogen.motion.JointDefinitionRecord;
import org.robokind.avrogen.motion.RobotDefinitionResponseRecord;
import org.robokind.impl.motion.messaging.command.PortableJointDefinition;
import org.robokind.impl.motion.messaging.command.PortableRobotResponseHeader;

public class PortableRobotDefinitionResponse
implements RobotDefinitionResponse {
    private RobotDefinitionResponseRecord myRecord;
    private PortableRobotResponseHeader myCachedHeader;
    private List<PortableJointDefinition> myCachedJointDefinitions;

    public PortableRobotDefinitionResponse(RobotDefinitionResponseRecord record) {
        if (record == null) {
            throw new NullPointerException();
        }
        this.myRecord = record;
        this.myCachedHeader = new PortableRobotResponseHeader(this.myRecord.responseHeader);
        this.myCachedJointDefinitions = new ArrayList<PortableJointDefinition>();
        for (JointDefinitionRecord rec : this.myRecord.joints) {
            this.myCachedJointDefinitions.add(new PortableJointDefinition(rec));
        }
    }

    public PortableRobotDefinitionResponse(RobotDefinitionResponse response) {
        if (response == null) {
            throw new NullPointerException();
        }
        if (response instanceof PortableRobotDefinitionResponse) {
            PortableRobotDefinitionResponse pr = (PortableRobotDefinitionResponse)response;
            this.myRecord = pr.getRecord();
            this.myCachedHeader = pr.myCachedHeader;
            this.myCachedJointDefinitions = pr.myCachedJointDefinitions;
            return;
        }
        this.setHeader(response.getResponseHeader());
        this.myRecord = new RobotDefinitionResponseRecord();
        this.myRecord.responseHeader = this.myCachedHeader.getRecord();
        this.myRecord.connected = response.getConnected();
        this.myRecord.enabled = response.getEnabled();
        int count = response.getJointDefinitions().size();
        this.myCachedJointDefinitions = new ArrayList<PortableJointDefinition>(count);
        this.myRecord.joints = new GenericData.Array(count, Schema.createArray((Schema)JointDefinitionRecord.SCHEMA$));
        for (RobotDefinitionResponse.JointDefinition def : response.getJointDefinitions()) {
            PortableJointDefinition pjd = new PortableJointDefinition(def);
            this.myCachedJointDefinitions.add(pjd);
            this.myRecord.joints.add((Object)pjd.getRecord());
        }
    }

    public PortableRobotDefinitionResponse(RobotResponse.RobotResponseHeader header, boolean connected, boolean enabled, List<RobotDefinitionResponse.JointDefinition> jointDefs) {
        this.setHeader(header);
        this.myRecord = new RobotDefinitionResponseRecord();
        this.myRecord.responseHeader = this.myCachedHeader.getRecord();
        this.myRecord.connected = connected;
        this.myRecord.enabled = enabled;
        int count = jointDefs.size();
        this.myCachedJointDefinitions = new ArrayList<PortableJointDefinition>(count);
        this.myRecord.joints = new GenericData.Array(count, Schema.createArray((Schema)JointDefinitionRecord.SCHEMA$));
        for (RobotDefinitionResponse.JointDefinition def : jointDefs) {
            PortableJointDefinition pjd = new PortableJointDefinition(def);
            this.myCachedJointDefinitions.add(pjd);
            this.myRecord.joints.add((Object)pjd.getRecord());
        }
    }

    public PortableRobotDefinitionResponse(RobotResponse.RobotResponseHeader header, Robot<? extends Joint> robot) {
        if (header == null || robot == null) {
            throw new NullPointerException();
        }
        this.setHeader(header);
        this.myRecord = new RobotDefinitionResponseRecord();
        this.myRecord.responseHeader = this.myCachedHeader.getRecord();
        this.myRecord.connected = robot.isConnected();
        this.myRecord.enabled = robot.isEnabled();
        int count = robot.getJointList().size();
        this.myCachedJointDefinitions = new ArrayList<PortableJointDefinition>(count);
        this.myRecord.joints = new GenericData.Array(count, Schema.createArray((Schema)JointDefinitionRecord.SCHEMA$));
        for (Joint joint : robot.getJointList()) {
            PortableJointDefinition pjd = new PortableJointDefinition(joint);
            this.myCachedJointDefinitions.add(pjd);
            this.myRecord.joints.add((Object)pjd.getRecord());
        }
    }

    private void setHeader(RobotResponse.RobotResponseHeader header) {
        this.myCachedHeader = header instanceof PortableRobotResponseHeader ? (PortableRobotResponseHeader)header : new PortableRobotResponseHeader(header);
    }

    public boolean getConnected() {
        return this.myRecord.connected;
    }

    public boolean getEnabled() {
        return this.myRecord.enabled;
    }

    public List<RobotDefinitionResponse.JointDefinition> getJointDefinitions() {
        return this.myCachedJointDefinitions;
    }

    public RobotResponse.RobotResponseHeader getResponseHeader() {
        return this.myCachedHeader;
    }

    public RobotDefinitionResponseRecord getRecord() {
        return this.myRecord;
    }
}

