/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.motion.osgi;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Session;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.robokind.api.common.osgi.lifecycle.AbstractLifecycleProvider;
import org.robokind.api.common.osgi.lifecycle.DescriptorListBuilder;
import org.robokind.api.common.osgi.lifecycle.ServiceLifecycleProvider;
import org.robokind.api.common.utils.Listener;
import org.robokind.api.motion.Robot;
import org.robokind.api.motion.messaging.MoveFrameListener;
import org.robokind.api.motion.messaging.RemoteRobotHost;
import org.robokind.api.motion.protocol.FrameSource;
import org.robokind.api.motion.protocol.MotionFrameEvent;
import org.robokind.api.motion.utils.RobotMoverFrameSource;
import org.robokind.api.motion.utils.RobotUtils;
import org.robokind.impl.motion.messaging.JMSRemoteRobotHost;

public class JMSRemoteRobotHostLifecycleProvider
extends AbstractLifecycleProvider<RemoteRobotHost, JMSRemoteRobotHost> {
    private static final Logger theLogger = Logger.getLogger(ServiceLifecycleProvider.class.getName());
    private static final String theDepRobotId = "robot";
    private static final String theDepConnectionId = "motionConnection";
    private static final String theDepRequestDestId = "requestDestination";
    private static final String theDepResponseDestId = "responseDestination";
    private static final String theDepMoveDestId = "moveDestination";
    private BundleContext myContext;
    private ServiceRegistration myFrameSourceReg;

    public JMSRemoteRobotHostLifecycleProvider(BundleContext context, Robot.Id robotId, String connId, String reqDestId, String respDestId, String moveDestId) {
        super(new DescriptorListBuilder().addId(theDepRobotId, Robot.class, "robotId", robotId.getRobtIdString()).addId(theDepConnectionId, Connection.class, "connectionId", connId).addId(theDepRequestDestId, Destination.class, "destinationId", reqDestId).addId(theDepResponseDestId, Destination.class, "destinationId", respDestId).addId(theDepMoveDestId, Destination.class, "destinationId", moveDestId).getDescriptors());
        if (context == null) {
            throw new NullPointerException();
        }
        this.myContext = context;
    }

    protected JMSRemoteRobotHost create(Map<String, Object> services) {
        Session session;
        Robot robot = (Robot)services.get(theDepRobotId);
        Connection con = (Connection)services.get(theDepConnectionId);
        Destination reqDest = (Destination)services.get(theDepRequestDestId);
        Destination respDest = (Destination)services.get(theDepResponseDestId);
        Destination moveDest = (Destination)services.get(theDepMoveDestId);
        Robot.Id id = robot.getRobotId();
        try {
            session = con.createSession(false, 2);
        }
        catch (JMSException ex) {
            theLogger.log(Level.WARNING, "Unable to create Session.", ex);
            return null;
        }
        RobotMoverFrameSource frameSource = new RobotMoverFrameSource(robot);
        MoveFrameListener moveHandler = new MoveFrameListener();
        this.myFrameSourceReg = RobotUtils.registerFrameSource((BundleContext)this.myContext, (Robot.Id)id, (FrameSource)frameSource);
        moveHandler.setRobotFrameSource(frameSource);
        try {
            JMSRemoteRobotHost host = new JMSRemoteRobotHost(robot, "sourceId", "destId", session, reqDest, respDest, moveDest, (Listener<MotionFrameEvent>)moveHandler);
            host.start();
            return host;
        }
        catch (Exception ex) {
            theLogger.log(Level.WARNING, "There was an error creating and starting the RemoteRobotHost.", ex);
            return null;
        }
    }

    protected void handleChange(String serviceId, Object service) {
    }

    public Class<RemoteRobotHost> getServiceClass() {
        return RemoteRobotHost.class;
    }
}

