/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.motion.messaging;

import org.apache.avro.util.Utf8;
import org.robokind.api.motion.Robot;
import org.robokind.api.motion.protocol.RobotResponse;
import org.robokind.avrogen.motion.RobotResponseHeaderRecord;

public class PortableRobotResponseHeader
implements RobotResponse.RobotResponseHeader {
    private RobotResponseHeaderRecord myRecord;
    private Robot.Id myCachedId;

    public PortableRobotResponseHeader(RobotResponseHeaderRecord record) {
        if (record == null) {
            throw new NullPointerException();
        }
        this.myRecord = record;
        this.myCachedId = new Robot.Id(this.myRecord.robotId.toString());
    }

    public PortableRobotResponseHeader(RobotResponse.RobotResponseHeader header) {
        if (header == null) {
            throw new NullPointerException();
        }
        if (header instanceof PortableRobotResponseHeader) {
            this.myRecord = ((PortableRobotResponseHeader)header).getRecord();
            this.myCachedId = new Robot.Id(this.myRecord.robotId.toString());
            return;
        }
        this.myCachedId = header.getRobotId();
        this.myRecord = new RobotResponseHeaderRecord();
        this.myRecord.robotId = new Utf8(this.myCachedId.getRobtIdString());
        this.myRecord.requestSourceId = new Utf8(header.getSourceId());
        this.myRecord.requestDestinationId = new Utf8(header.getDestinationId());
        this.myRecord.requestType = new Utf8(header.getRequestType());
        this.myRecord.requestTimestampMillisecUTC = header.getRequestTimestampMillisecUTC();
        this.myRecord.responseTimestampMillisecUTC = header.getResponseTimestampMillisecUTC();
    }

    public PortableRobotResponseHeader(Robot.Id robotId, String sourceId, String destId, String commandType, long requestTimestampMillisecUTC, long responseTimestampMillisecUTC) {
        this.myCachedId = robotId;
        this.myRecord = new RobotResponseHeaderRecord();
        this.myRecord.robotId = new Utf8(this.myCachedId.getRobtIdString());
        this.myRecord.requestSourceId = new Utf8(sourceId);
        this.myRecord.requestDestinationId = new Utf8(destId);
        this.myRecord.requestType = new Utf8(commandType);
        this.myRecord.requestTimestampMillisecUTC = requestTimestampMillisecUTC;
        this.myRecord.responseTimestampMillisecUTC = responseTimestampMillisecUTC;
    }

    public Robot.Id getRobotId() {
        return this.myCachedId;
    }

    public String getSourceId() {
        return this.myRecord.requestSourceId.toString();
    }

    public String getDestinationId() {
        return this.myRecord.requestDestinationId.toString();
    }

    public String getRequestType() {
        return this.myRecord.requestType.toString();
    }

    public long getRequestTimestampMillisecUTC() {
        return this.myRecord.requestTimestampMillisecUTC;
    }

    public long getResponseTimestampMillisecUTC() {
        return this.myRecord.responseTimestampMillisecUTC;
    }

    public RobotResponseHeaderRecord getRecord() {
        return this.myRecord;
    }
}

