/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.motion.osgi;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.robokind.api.common.services.ConfigurationLoader;
import org.robokind.api.common.services.ConfigurationWriter;
import org.robokind.api.common.services.ServiceFactory;
import org.robokind.api.common.services.ServiceUtils;
import org.robokind.api.motion.jointgroup.RobotJointGroupFactory;
import org.robokind.api.motion.messaging.RobotResponseFactory;
import org.robokind.impl.motion.config.RobotConfigXMLFileLoader;
import org.robokind.impl.motion.config.RobotConfigXMLReader;
import org.robokind.impl.motion.jointgroup.RobotJointGroupConfigXMLReader;
import org.robokind.impl.motion.jointgroup.RobotJointGroupXMLFileLoader;
import org.robokind.impl.motion.messaging.PortableRobotResponse;
import org.robokind.impl.motion.sync.SynchronizedRobotConfigLoader;
import org.robokind.impl.motion.sync.SynchronizedRobotConfigWriter;

public class Activator
implements BundleActivator {
    private static final Logger theLogger = Logger.getLogger(Activator.class.getName());

    public void start(BundleContext context) throws Exception {
        theLogger.log(Level.INFO, "MotionAPI Activation Begin.");
        ServiceUtils.registerConfigLoader((BundleContext)context, (ConfigurationLoader)new RobotConfigXMLReader(context));
        ServiceUtils.registerConfigLoader((BundleContext)context, (ConfigurationLoader)new RobotConfigXMLFileLoader(context));
        ServiceUtils.registerConfigLoader((BundleContext)context, (ConfigurationLoader)new RobotJointGroupConfigXMLReader());
        ServiceUtils.registerConfigLoader((BundleContext)context, (ConfigurationLoader)new RobotJointGroupXMLFileLoader());
        ServiceUtils.registerFactory((BundleContext)context, (ServiceFactory)new RobotJointGroupFactory());
        ServiceUtils.registerConfigLoader((BundleContext)context, (ConfigurationLoader)new SynchronizedRobotConfigLoader());
        ServiceUtils.registerConfigWriter((BundleContext)context, (ConfigurationWriter)new SynchronizedRobotConfigWriter(), null);
        context.registerService(RobotResponseFactory.class.getName(), (Object)new PortableRobotResponse.Factory(), null);
        theLogger.log(Level.INFO, "MotionAPI Activation Complete.");
    }

    public void stop(BundleContext context) throws Exception {
    }
}

