/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.motion.sync;

import org.apache.avro.util.Utf8;
import org.robokind.api.common.position.NormalizedDouble;
import org.robokind.api.motion.Joint;
import org.robokind.api.motion.sync.SynchronizedJointConfig;
import org.robokind.avrogen.motion.SynchronizedJointConfigRecord;

public class PortableSynchronizedJointConfig
implements SynchronizedJointConfig {
    private SynchronizedJointConfigRecord myRecord;
    private Joint.Id myCachedId;
    private NormalizedDouble myCachedDefPos;

    public PortableSynchronizedJointConfig(SynchronizedJointConfigRecord record) {
        if (record == null) {
            throw new NullPointerException();
        }
        this.setRecord(record);
    }

    public PortableSynchronizedJointConfig(SynchronizedJointConfig conf) {
        if (conf == null) {
            throw new NullPointerException();
        }
        if (conf instanceof PortableSynchronizedJointConfig) {
            this.setRecord(((PortableSynchronizedJointConfig)conf).getRecord());
            return;
        }
        this.myRecord = new SynchronizedJointConfigRecord();
        this.myRecord.jointId = conf.getJointId().getLogicalJointNumber();
        this.myRecord.name = new Utf8(conf.getName());
        NormalizedDouble def = conf.getDefaultPosition();
        if (def != null) {
            this.myRecord.defaultPosition = def.getValue();
        }
        this.setRecord(this.myRecord);
    }

    public PortableSynchronizedJointConfig(Joint.Id jointId, String name, NormalizedDouble defPos) {
        if (jointId == null || name == null) {
            throw new NullPointerException();
        }
        this.myCachedId = jointId;
        this.myCachedDefPos = defPos;
        this.myRecord = new SynchronizedJointConfigRecord();
        this.myRecord.jointId = this.myCachedId.getLogicalJointNumber();
        this.myRecord.name = new Utf8(name);
        if (this.myCachedDefPos != null) {
            this.myRecord.defaultPosition = this.myCachedDefPos.getValue();
        }
    }

    private void setRecord(SynchronizedJointConfigRecord record) {
        this.myRecord = record;
        this.myCachedId = new Joint.Id(this.myRecord.jointId);
        Double def = this.myRecord.defaultPosition;
        if (def != null) {
            this.myCachedDefPos = new NormalizedDouble(def.doubleValue());
        }
    }

    public Joint.Id getJointId() {
        return this.myCachedId;
    }

    public String getName() {
        return this.myRecord.name.toString();
    }

    public NormalizedDouble getDefaultPosition() {
        return this.myCachedDefPos;
    }

    public SynchronizedJointConfigRecord getRecord() {
        return this.myRecord;
    }
}

