/*
 * Copyright 2011 Hanson Robokind LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.robokind.impl.motion.osgi;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.robokind.impl.motion.config.RobotConfigXMLFileLoader;
import org.robokind.impl.motion.config.RobotConfigXMLReader;
import org.robokind.impl.motion.jointgroup.RobotJointGroupXMLFileLoader;
import org.robokind.impl.motion.jointgroup.RobotJointGroupConfigXMLReader;
import org.robokind.api.motion.jointgroup.RobotJointGroupFactory;
import org.robokind.api.common.services.ServiceUtils;
import org.robokind.api.motion.messaging.RobotResponseFactory;
import org.robokind.impl.motion.messaging.PortableRobotResponse;
import org.robokind.impl.motion.sync.SynchronizedRobotConfigLoader;
import org.robokind.impl.motion.sync.SynchronizedRobotConfigWriter;

/**
 * 
 * @author Matthew Stevenson <www.robokind.org>
 */
public class Activator implements BundleActivator {
    private final static Logger theLogger = Logger.getLogger(Activator.class.getName());
    
    @Override
    public void start(BundleContext context) throws Exception {
        theLogger.log(Level.INFO, "MotionAPI Activation Begin.");
        ServiceUtils.registerConfigLoader(
                context, new RobotConfigXMLReader(context));
        ServiceUtils.registerConfigLoader(
                context, new RobotConfigXMLFileLoader(context));
        ServiceUtils.registerConfigLoader(
                context, new RobotJointGroupConfigXMLReader());
        ServiceUtils.registerConfigLoader(
                context, new RobotJointGroupXMLFileLoader());
        ServiceUtils.registerFactory(
                context, new RobotJointGroupFactory());
        ServiceUtils.registerConfigLoader(
                context, new SynchronizedRobotConfigLoader());
        ServiceUtils.registerConfigWriter(
                context, new SynchronizedRobotConfigWriter(), null);
        context.registerService(RobotResponseFactory.class.getName(), 
                new PortableRobotResponse.Factory(), null);
        theLogger.log(Level.INFO, "MotionAPI Activation Complete.");
    }

    @Override
    public void stop(BundleContext context) throws Exception {}

}
